UNIT VTPartitura;

INTERFACE

USES ModUnit, PlayMod,
     Output43;

VAR
  IsBig       : BOOLEAN;
  PartWin     : PWindow;
{
  ForceReDraw : BOOLEAN;
}





PROCEDURE SetPartWindow(x, y, p, f: WORD);

PROCEDURE SetBigPartWindow;

PROCEDURE SetSmallPartWindow;

PROCEDURE DrawPartiture(mdpos, mdseq: WORD; pp: PPattern);




IMPLEMENTATION

USES VTPlay, VTWins, VTBitmaps,
     HexConversions;

TYPE
  TFullNoteStr = STRING[18];

VAR
  wx, wn,
  py, fy,
  hp, hf,

  PastNotes,
  FutNotes,
  TotNotes,
  ActNote,
  FirstNote   : WORD;

  ps          : ARRAY[1..33] OF ARRAY[1..4] OF TFullNoteStr;
  fs          : ARRAY[1..33] OF ARRAY[1..4] OF BOOLEAN;
  ls          : ARRAY[1..33] OF ARRAY[1..4] OF LONGINT;

  Permit      : ARRAY[1..4] OF BOOLEAN;

  omdpos,
  omdseq      : WORD;

  wPastIdx,
  wActIdx,
  wFutIdx     : TWindow;
  wPast,
  wAct,
  wFut        : T4Window;





PROCEDURE SetPartWindow(x, y, p, f: WORD);
  BEGIN
    wx := x;
    wn := 20;
    py := y;
    fy := y + p + 5;
    hp := p + 2;
    hf := f + 2;

    FillChar(Permit, SIZEOF(Permit), 0);

    PastNotes   := p;
    FutNotes    := f;
    TotNotes    := p+f+1;
    ActNote     := p+1;
  END;




PROCEDURE SetBigPartWindow;
  BEGIN
    wPastIdx := wPartPastBIdx;
    wActIdx  := wPartActBIdx;
    wFutIdx  := wPartFutBIdx;
    wPast    := wPartPastBig;
    wAct     := wPartActBig;
    wFut     := wPartFutBig;
    PartWin  := @wPartBig;

    PastNotes   := 16;
    FutNotes    := 16;
    TotNotes    := 33;
    ActNote     := 17;
    IsBig       := TRUE;
  END;




PROCEDURE SetSmallPartWindow;
  BEGIN
    wPastIdx := wPartPastIdx;
    wActIdx  := wPartActIdx;
    wFutIdx  := wPartFutIdx;
    wPast    := wPartPast;
    wAct     := wPartAct;
    wFut     := wPartFut;
    PartWin  := @wPartSmall;

    PastNotes   := 5;
    FutNotes    := 5;
    TotNotes    := 11;
    ActNote     := 6;
    IsBig       := FALSE;
  END;





PROCEDURE InsertStr(VAR s, t: STRING; p: WORD); ASSEMBLER;
  ASM
        PUSH    DS
        CLD
        LDS     SI,t
        LES     DI,s
        MOV     AX,p
        INC     AX
        ADD     DI,AX
        LODSB
        MOV     CL,AL
        XOR     CH,CH
        REP MOVSB
        POP     DS
  END;



PROCEDURE StrNote(nt: TModNote; VAR s: TFullNoteStr);
  CONST
    Commands : ARRAY[0..32] OF STRING[4] = (
      'ARPG', 'TPUP', 'TPDN', 'NOTP',
      'VIBR', 'TNVS', 'VBVS', 'TREM',
      '????', 'SOFF', 'VOLS', 'JUMP',
      'VOL=', 'BRCK', 'FILT', 'SPED',

      'FILT', 'FPUP', 'FPDN', 'GLSS',
      'VBCT', 'FNTN', 'LOOP', 'TRCT',
      '????', 'RNOT', 'VFUP', 'VFDN',
      'NCUT', 'NDLY', 'PDLY', 'FUNK',

      ''
    );
  VAR
    bs : STRING[16];
  BEGIN

    IF (nt.freq = 0) AND (nt.sample = 0) AND (nt.comm = mcNone) THEN

      s := '  '

    ELSE BEGIN

      s := '                  ';

      IF (nt.freq <> 0) OR (nt.sample <> 0) THEN BEGIN
        NoteFreq(nt.freq, bs);
        InsertStr(s, bs, 1);
        IF nt.sample = 0 THEN BEGIN
          bs := '--';
          InsertStr(s, bs, 5);
        END ELSE BEGIN
          STR(nt.sample : 2, bs);
          IF bs[1] = ' ' THEN bs[1] := '0';
          InsertStr(s, bs, 5);
        END;
      END ELSE BEGIN
        bs := '';
        InsertStr(s, bs, 1);
      END;

      InsertStr(s, Commands[ORD(nt.comm)], 8);

      IF nt.comm < mcSetFilter THEN BEGIN
        bs := HexDigit(ORD(nt.comm));
        InsertStr(s, bs, 13);
        bs := HexByte(nt.param);
        InsertStr(s, bs, 15);
      END ELSE IF nt.comm < mcNone THEN BEGIN
        bs := HexByte(ORD(nt.comm)+$D0);
        InsertStr(s, bs, 13);
        bs := HexDigit(nt.param);
        InsertStr(s, bs, 16);
      END ELSE BEGIN
        bs := '';
        InsertStr(s, bs, 12);
      END;

    END;
  END;




PROCEDURE DrawPartiture(mdpos, mdseq: WORD; pp: PPattern);
  CONST
    EmptyLine : STRING[18] = '                  ';
    count : WORD = 0;
  VAR
    nn   : WORD;
    n, w,
    k, p : INTEGER;
    i, j : WORD;
    nt   : TModNote;
    strn : STRING;
  BEGIN

    IF NOT (PartWin^.vis AND PartWin^.act) THEN EXIT;

    FOR j := 1 TO 4 DO BEGIN

      IF NOT Permisos[j-1] THEN BEGIN
        IF Permit[j] OR PartWin^.forz THEN BEGIN
          WITH wPast[j] DO BEGIN
            FOR i := 1 TO PastNotes DO
              DirectWriteAttr(ParseCoords(x + 1, y+i), EmptyLine, BYTE(col[3]));
            WriteVTLogo(ParseCoords(x + 6, y+(PastNotes - 1) DIV 2 - 1));
          END;

          WITH wAct[j] DO BEGIN
            FOR i := 1 TO 2 DO
              DirectWriteAttr(ParseCoords(x + 1, y+i), EmptyLine, BYTE(col[1]));
            WriteVTNoPartAct(ParseCoords(x + 2, y+1));
          END;

          WITH wFut[j] DO BEGIN
            FOR i := 1 TO FutNotes DO
              DirectWriteAttr(ParseCoords(x + 1, y+i), EmptyLine, BYTE(col[3]));
            WriteVTLogo(ParseCoords(x + 6, y+(FutNotes - 1) DIV 2 - 1));
          END;
        END;
      END;

      Permit[j] := Permisos[j-1];
    END;
{
    PartWin^.forz := TRUE;
}
    IF PartWin^.forz OR (mdseq <> omdseq) OR
       (WORD(mdpos - omdpos) >= FutNotes) THEN BEGIN

      FirstNote := 1;

      n := mdpos - PastNotes;
      w := 1;

      FOR i := 1 TO PastNotes DO BEGIN
        IF WORD(n) < 64 THEN
          FOR j := 1 TO 4 DO BEGIN
            ls[w][j] := LONGINT(pp^[n][j]);
            fs[w][j] := TRUE;
            UnpackNote(pp^[n][j], nt);
            StrNote(nt, ps[w][j]);
          END
        ELSE 
          FOR j := 1 TO 4 DO BEGIN
            ls[w][j] := $FFFFFFFF;
            fs[w][j] := TRUE;
            ps[w][j] := '                  ';
          END;
        INC(n); INC(w);
      END;

      FOR j := 1 TO 4 DO BEGIN
        ls[w][j] := LONGINT(pp^[n][j]);
        fs[w][j] := TRUE;
        UnpackNote(pp^[n][j], nt);
        StrNote(nt, ps[w][j]);
      END;
      INC(n); INC(w);

      FOR i := 1 TO FutNotes DO BEGIN
        IF WORD(n) < 64 THEN
          FOR j := 1 TO 4 DO BEGIN
            ls[w][j] := LONGINT(pp^[n][j]);
            fs[w][j] := TRUE;
            UnpackNote(pp^[n][j], nt);
            StrNote(nt, ps[w][j]);
          END
        ELSE
          FOR j := 1 TO 4 DO BEGIN
            ls[w][j] := $FFFFFFFF;
            fs[w][j] := TRUE;
            ps[w][j] := '                  ';
          END;
        INC(n); INC(w);
      END;
{
      INC(Count);
      STR(Count : 5, strn); DirectWriteAttr(0, strn, $70);
}
    END ELSE BEGIN

      k := mdpos - omdpos;
      IF k = 0 THEN EXIT;
      IF k > 0 THEN BEGIN
        p := 1;
        n := omdpos + FutNotes + 1;
      END;
{
      INC(Count);
      STR(Count : 5, strn); DirectWriteAttr(0, strn, $70);
}
      w  := FirstNote;
      nn := ((FirstNote - 1 + TotNotes + k) MOD TotNotes) + 1;
      FOR i := 1 TO TotNotes - k DO BEGIN
        FOR j := 1 TO 4 DO
          fs[nn][j] := ls[nn][j] <> ls[w][j];
        w  := (w  MOD TotNotes) + 1;
        nn := (nn MOD TotNotes) + 1;
      END;

      w := FirstNote;
      FirstNote := ((FirstNote - 1 + TotNotes + k) MOD TotNotes) + 1;

      FOR i := 1 TO ABS(k) DO BEGIN
        IF WORD(n) < 64 THEN
          FOR j := 1 TO 4 DO BEGIN
            fs[w][j] := TRUE;{ls[w][j] <> LONGINT(pp^[n][j]);}
            ls[w][j] := LONGINT(pp^[n][j]);
            UnpackNote(pp^[n][j], nt);
            StrNote(nt, ps[w][j]);
          END
        ELSE
          FOR j := 1 TO 4 DO BEGIN
            fs[w][j] := ls[w][j] <> $FFFFFFFF;
            ls[w][j] := $FFFFFFFF;
            ps[w][j] := '123456789012345678';
          END;
        INC(n, p);
        w := ((w - 1 + TotNotes + p) MOD TotNotes) + 1;
      END;

    END;

    n  := FirstNote;
    nn := mdpos - PastNotes;

    FOR i := 1 TO PastNotes DO BEGIN
      WITH wPastIdx DO BEGIN
        STR(nn : 2, strn);
        IF nn < 64 THEN
          DirectWriteAttr(ParseCoords(x+1, y+i), strn, BYTE(col[1]))
        ELSE
          DirectWriteAttr(ParseCoords(x+1, y+i), '  ', BYTE(col[2]));
      END;

{
      IF ps[n][1][0] <> #0 THEN
}
        FOR j := 1 TO 4 DO
          IF fs[n][j] THEN
            IF Permisos[j-1] THEN
              WITH wPast[j] DO IF ls[n][j] = $FFFFFFFF THEN
                DirectWriteAttr(ParseCoords(x + 1, y+i), ps[n][j], BYTE(col[2]))
              ELSE
                DirectWriteAttr(ParseCoords(x + 1, y+i), ps[n][j], BYTE(col[1]));
      n := (n MOD TotNotes) + 1;
      INC(nn);
    END;

    WITH wActIdx DO BEGIN
      IF nn < 100 THEN
        STR(nn : 2, strn)
      ELSE
        strn := '  ';
      DirectWriteBig(ParseCoords(x+1, y+1), strn)
    END;

    FOR j := 1 TO 4 DO
      IF fs[n][j] THEN
        IF Permisos[j-1] THEN
          WITH wAct[j] DO BEGIN
            RectAttr       (ParseCoords(x+1, y+1), 18, 2, BYTE(col[1]));
            DirectWriteBig (ParseCoords(x+1, y+1), ps[n][j]);
          END;
    n := (n MOD TotNotes) + 1;
    INC(nn);

    FOR i := 1 TO FutNotes DO BEGIN
      WITH wFutIdx DO BEGIN
        STR(nn : 2, strn);
        IF nn < 64 THEN
          DirectWriteAttr(ParseCoords(x+1, y+i), strn, BYTE(col[1]))
        ELSE
          DirectWriteAttr(ParseCoords(x+1, y+i), '  ', BYTE(col[2]));
      END;

{
      IF ps[n][1][0] <> #0 THEN
}
        FOR j := 1 TO 4 DO
          IF fs[n][j] THEN
            IF Permisos[j-1] THEN
              WITH wFut[j] DO IF ls[n][j] = $FFFFFFFF THEN
                DirectWriteAttr(ParseCoords(x + 1, y+i), ps[n][j], BYTE(col[2]))
              ELSE
                DirectWriteAttr(ParseCoords(x + 1, y+i), ps[n][j], BYTE(col[1]));
      n := (n MOD TotNotes) + 1;
      INC(nn);
    END;

    omdseq := mdseq;
    omdpos := mdpos;

    PartWin^.forz := FALSE;

  END;




END.
