PROGRAM ShellVT;

{$M 4000, 0, 655360}

USES Dos,
     VTSpecial, VTGlobal, VTCfg,
     SoundDevices, DevSB, DevSbDac, DevDAC, DevSpkr, DevAdlib,
     PlayMod, ModUnit,
     DOSMem, Debugging;

CONST
  NombreApp = 'ShellVT';

  AppID : STRING[Length(NombreApp) + 2 + Length(Version) + Length(BetaStr)] =
            NombreApp+' v'+Version+BetaStr;

VAR
  Path    : PathStr;
  Dir     : DirStr;
  Name    : NameStr;
  Ext     : ExtStr;
  SearchR : SearchRec;
  s       : STRING;
  i, r    : WORD;

BEGIN

  WriteLn;
  WriteLn('Ŀ');
  WriteLn(' '+NombreApp+'. Versin residente del VangeliSTracker, v'+Version+' ');
  WriteLn('                 (C) 1992 VangeliSTeam                 ');
  WriteLn('');

  VTResidentCheck(AppID);

  Debugging.Debug := FALSE;

  IF ShellLoopMod THEN
    BEGIN
      LoopMod      := TRUE;
      ForceLoopMod := TRUE;
    END;

  s := ParamStr(2);
  IF (s <> '') AND (LocateDevice(s) <> NIL) THEN
    DevID := s;

  SetDevice(LocateDevice(DevID));

  s := ParamStr(3);
  IF s <> '' THEN
    BEGIN
      VAL(s, i, r);
      IF r = 0 THEN ShellHz := i;
    END;

  ChangeSamplingRate(ShellHz);
  InitDOSMem;

  Path := FExpand(ParamStr(1));
  FSplit(Path, Dir, Name, Ext);
  IF Ext = '' THEN Ext := '.MOD';
  Path := Dir + Name + Ext;

  FindFirst(Path, ReadOnly, SearchR);
  IF (DosError = 0) AND LoadMod(Dir + SearchR.Name) THEN
    BEGIN
      PlayStart;

      DMAOffset := 1;

      SwapVectors;
      Exec(ShellPath, ShellParam);
      SwapVectors;


      PlayStop;
      EndSampling;

      WriteLn;
      WriteLn('Ŀ');
      WriteLn(' ShellVT desinstalado. ');
      WriteLn('');
    END
  ELSE
    WriteLn(#13'Error en el fichero MOD.');

END.
