
CSEG    SEGMENT PARA    PUBLIC 'code'
        ASSUME  CS:CSEG,DS:CSEG
        ORG     100h

Capture PROC

                JMP     INSTALL

Old_Int9_Vector LABEL   DWORD
Old_Int9_Offs   DW      ?
Old_Int9_Seg    DW      ?

Palette_Name    DB      'PICTURE.PAL',0
Palette_Handle  DW      0
TempPalette     DB      256*3 DUP (?)

Save_Name       DB      'PICTURE.DAT',0
Save_Handle     DW      0


New_Int9:

        PUSHF
        CALL    CS:Old_Int9_Vector

        PUSH    ES
        PUSH    AX
        PUSH    BX

        MOV     AX,40h          ;Keyboard flag in ROM BIOS area
        MOV     ES,AX
        MOV     BX,17h
        MOV     AL,ES:[BX]
        AND     AL,05h          ;Mask out bits 1 and 3
        CMP     AL,5            ;Control and Right Shift pressed?
        JE      ScrDump         ;Yes, dump screen

        POP     BX              ;restore before quitting
        POP     AX
        POP     ES
        IRET


ScrDump:

        PUSH    DS              ;Preserve DS

        MOV     AX,CS           ;Setup pointer to file name
        MOV     DS,AX           ;into DS:DX

        LEA     DX,Save_Name
        MOV     CX,0            ;Normal attribute for the file
        MOV     AH,3CH          ;DOS function to open file
        INT     21H             ;Ask DOS to open the file
        JC      Dump_Error      ;Quit on open error
        MOV     Save_Handle,AX  ;Save the handle to the opened file

        MOV     AX,0A000h
        MOV     DS,AX
        XOR     DX,DX
        MOV     CX,64000          ;Number of bytes to write
        MOV     BX,CS:Save_Handle ;File handle
        MOV     AH,40H            ;DOS function to write into a file
        INT     21H             ;Ask DOS to write data into a file

Close_Dump_File:
        MOV     BX,CS:Save_Handle ;Fetch handle
        MOV     AH,3EH            ;DOS function to close a file
        INT     21H             ;Ask DOS to close the file

Dump_Done:

        POP     DS              ;Restore DS
        JMP     PalDump

Dump_Error:                     ;This is where we can add error
        JMP     Dump_Done       ;reporting


;***********************************************************************
; Save current screen palette into a file PAL.001                      *
; Assumes screen is in 320x200x256 (Mode 13h)                          *
;***********************************************************************

PalDump:

        PUSH    DS              ;Preserve DS

        MOV     AX,CS           ;Setup pointer to file name
        MOV     DS,AX           ;into DS:DX

        LEA     DX,Palette_Name
        MOV     CX,0            ;Normal attribute for the file
        MOV     AH,3CH          ;DOS function to open file
        INT     21H             ;Ask DOS to open the file
        JC      ADump_Error       ;Quit on open error
        MOV     Palette_Handle,AX ;Save the handle to the opened file

        MOV     AX,CS
        MOV     DS,AX
        MOV     DX,3C7h
        MOV     AL,0h
        OUT     DX,AL
        MOV     CX,256*3
        MOV     DX,3C9h
        XOR     BX,BX
        CLD
Dump_Palette_Loop:
        IN      AL,DX
        MOV     TempPalette[BX],AL
        INC     BX
        LOOP    Dump_Palette_Loop


        MOV     DX,OFFSET TempPalette
        MOV     CX,256*3              ;Number of bytes to write
        MOV     BX,CS:Palette_Handle  ;File handle
        MOV     AH,40H                ;DOS function to write into a file
        INT     21H                   ;Ask DOS to write data into a file

AClose_Dump_File:
        MOV     BX,CS:Palette_Handle  ;Fetch handle
        MOV     AH,3EH                ;DOS function to close a file
        INT     21H                   ;Ask DOS to close the file
ADump_Done:

        POP     DS              ;Restore DS
        JMP     Quit
ADump_Error:                    ;This is where we can add error
        JMP     ADump_Done      ;reporting

Quit:
        POP             BX      ;restore before quitting
        POP             AX
        POP             ES
        IRET

End_Of_Resident_Code    LABEL   BYTE


Message DB      'Capture v1.0 installed.',0Dh,0Ah
        DB      'Capture is a 320x200x256 screen capture utility which saves the contents',0Dh,0Ah
        DB      'of the screen into the file PICTURE.DAT and the current palette into',0Dh,0Ah
        DB      'PICTURE.PAL',0Dh,0Ah
        DB      'To activate, press Control and Right Shift Key',0Dh,0Ah,'$'

Err_Message     DB      'Capture v1.0 already installed.',0Dh,0Ah,0Dh,0Ah,'$'

Install:                                ;Get keyboard interrupt vector

        MOV     AH,35h                  ;Get interrupt vector fn
        MOV     AL,9                    ;Int 9
        INT     21h

        CMP     BX,OFFSET New_Int9      ;Are we installed yet?
        JNE     Do_Install              ;If not, install, else exit

        MOV     DX,OFFSET Err_Message   ;Write already installed
        MOV     AH,9
        INT     21h
        INT     20h                     ;And exit
        
Do_Install:
        MOV     Old_Int9_Offs,BX        ;Otherwise, save old keyboard interrupt address
        MOV     Old_Int9_Seg,ES

        MOV     DX,OFFSET Message       ;Print install message
        MOV     AH,9                    ;Print string 
        INT     21h

        MOV     AH,25h                  ;Set interrupt fn
        MOV     AL,9                    ;Int 9
        MOV     DX,OFFSET New_Int9      ;to new address
        INT     21h

        MOV     DX,OFFSET End_Of_Resident_Code+1
        INT     27h

Capture         ENDP

CSEG            ENDS

                END     Capture


