Program Grid3D;

  Const VGA_Segment = $A000;
        CGA_CharSet_Seg = $0F000;
        CGA_CharSet_Ofs = $0FA6E;
        CharLength      = 8;
        NumChars        = 256;

        GridHeight = 60;
        PerspPointXPos = 160;
        PerspPointYPos = 75;
        LineLength = 80;

        RecLength = 16;
        RecWidth = 8;
        StartHeight = 15;

        FirstColor : Array[1..3] Of Byte = (53,53,53);
        SecondColor : Array[1..3] Of Byte = (5,15,43);

        {* Instructions, 1=North, 2=Northeast, 3=East, 4=Southeast,
                         5=South, 6=Southwest, 7=West, 8=Northwest   *}

        NumInstr = 144;
        Instructions : Array[1..NumInstr] Of Byte =
          (  1,1,1,1,1,1,1,1, 2,2,2,2,2,2,2,2, 3,3,3,3,3,3,3,3,
             3,3,3,3,3,3,3,3, 3,3,3,3,3,3,3,3, 3,3,3,3,3,3,3,3,
             3,3,3,3,3,3,3,3, 3,3,3,3,3,3,3,3, 4,4,4,4,4,4,4,4,
             5,5,5,5,5,5,5,5, 6,6,6,6,6,6,6,6, 7,7,7,7,7,7,7,7,
             7,7,7,7,7,7,7,7, 7,7,7,7,7,7,7,7, 7,7,7,7,7,7,7,7,
             7,7,7,7,7,7,7,7, 7,7,7,7,7,7,7,7, 8,8,8,8,8,8,8,8  );


        PicXLen = 264;
        PicYLen = 30;
        PicXPos = (320-PicXLen) Div 2;
        PicYPos = GridHeight+2;


        NumSteps = 60;
        AngleStep = 2*Pi/NumSteps;

DispStr : String[200] =
        '...LOADER BY FRED NIETZCHE       -THE ARKHAM ASYLUM-        '+
        '(301)NOW-DOWN      9600+ ONLY, SYSOP: The JokeR.            '+
        'GIVE CenterPoint! BBS A RING (301)309-0144, 9600+ ONLY.     '+
        '                  ';

        NumDispChars = 198;
        TextYPos = 125;
        CharColor = 150;


Picture : Array[1..7920] Of Byte = 
(* Size is 264 by 30 *)
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,200,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,200,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,200,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,200,201,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,200,202,201,203,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,200,202,201,203,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,201,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,200,202,201,203,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,200,202,201,203,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,204,
202,205,206,207,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,200,204,202,205,201,209,203,210,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,200,202,201,203,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,200,204,202,205,201,209,203,210,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,204,
202,205,206,207,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,204,211,
212,209,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,200,204,211,212,209,208,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,200,204,202,205,206,207,208,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,200,204,211,212,209,208,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,200,213,214,211,212,201,
209,203,210,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,204,211,212,209,
208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,
204,211,212,209,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,200,213,214,211,212,201,209,203,210,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,200,204,211,212,209,208,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,200,204,202,205,201,209,
203,210,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,200,204,211,212,209,208,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,204,211,
212,209,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,200,204,202,205,201,209,203,210,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,200,204,211,212,209,208,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,200,204,202,205,201,209,203,210,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,200,204,211,212,209,208,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,204,211,212,209,
208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,200,204,202,205,201,209,203,210,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
200,204,211,212,209,208,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,200,0,200,204,202,205,206,207,208,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,0,0,0,
200,214,205,206,203,0,0,0,200,204,211,212,209,208,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,200,204,211,212,209,208,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
200,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,
0,200,204,202,205,206,207,208,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,204,
211,212,209,208,0,0,0,0,0,0,0,0,200,0,0,0,0,0,0,
0,0,200,0,0,0,0,0,0,0,0,0,0,0,200,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,200,0,0,200,204,202,205,206,207,208,0,0,0,
0,0,0,0,0,0,0,200,204,202,205,206,207,208,0,200,204,202,205,
201,209,203,210,0,0,200,204,211,212,209,208,0,200,213,214,211,212,201,
209,203,210,0,0,0,0,0,0,0,200,204,211,212,209,208,0,0,0,
200,202,201,203,0,0,0,0,0,0,0,200,213,204,202,211,212,201,209,
207,208,210,0,0,0,0,0,0,0,0,200,204,202,205,206,207,208,0,
0,0,200,202,201,203,0,0,0,0,0,200,202,201,203,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,0,0,200,
204,202,205,206,207,208,0,0,0,0,0,0,0,0,200,0,0,200,204,
202,205,206,207,208,0,0,0,200,0,0,200,213,204,202,211,212,201,209,
207,208,210,0,200,204,202,205,201,209,203,210,0,0,0,200,204,211,212,
209,208,0,0,200,204,202,205,206,207,208,0,0,200,204,202,205,206,207,
208,0,0,0,0,0,200,204,202,205,206,207,208,0,0,0,200,202,201,
203,0,0,0,0,0,200,202,201,203,0,0,0,0,0,0,0,0,0,
0,0,0,0,200,0,0,0,200,204,202,205,206,207,208,0,0,0,0,
0,0,0,0,0,0,200,204,202,205,206,207,208,0,200,204,202,205,206,
207,208,0,0,200,204,211,212,209,208,0,0,0,200,214,205,206,203,0,
0,0,0,0,0,0,0,0,200,204,211,212,209,208,0,200,204,202,205,
206,207,208,0,0,0,0,0,200,214,205,206,203,0,0,0,200,214,205,
206,203,0,0,0,0,0,0,0,0,200,204,211,212,209,208,0,200,204,
202,205,206,207,208,0,0,200,204,202,205,206,207,208,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,200,0,0,0,200,204,
202,205,206,207,208,0,0,0,0,0,0,0,200,204,202,205,206,207,208,
0,0,0,200,202,201,203,0,0,0,0,200,204,202,205,206,207,208,0,
0,0,0,0,200,214,205,206,203,0,0,0,0,200,204,211,212,209,208,
0,0,0,200,204,211,212,209,208,0,0,0,200,204,211,212,209,208,0,
0,0,0,0,0,200,204,211,212,209,208,0,200,204,202,205,206,207,208,
0,0,200,204,202,205,206,207,208,0,0,0,0,0,0,0,0,0,0,
0,0,200,0,0,0,200,204,202,205,206,207,208,0,0,0,0,0,0,
0,0,0,0,200,204,211,212,209,208,0,0,200,204,202,205,206,207,208,
0,0,200,204,211,212,209,208,0,0,0,200,211,209,0,0,0,0,0,
0,0,0,0,0,0,200,204,202,205,201,209,203,210,0,200,214,205,206,
203,0,0,0,0,0,200,204,211,212,209,208,0,0,200,204,211,212,209,
208,0,0,0,0,0,0,0,200,204,202,205,201,209,203,210,0,200,204,
202,205,201,209,203,210,0,200,204,211,212,209,208,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,200,0,0,0,200,204,202,205,
206,207,208,0,0,0,0,0,0,0,200,204,202,205,206,207,208,0,0,
0,0,200,211,209,0,0,0,0,0,200,204,202,205,206,207,208,0,0,
0,0,0,200,211,209,0,0,0,0,0,200,204,211,212,209,208,0,0,
0,200,204,211,212,209,208,0,0,0,200,204,211,212,209,208,0,0,0,
0,0,0,200,204,202,205,201,209,203,210,0,200,204,202,205,201,209,203,
210,0,200,204,211,212,209,208,0,0,0,0,0,0,0,0,0,0,200,
0,0,0,0,0,200,204,202,205,206,207,208,0,0,0,0,0,0,0,
0,0,200,204,211,212,209,208,0,0,200,204,202,205,206,207,208,0,0,
200,204,211,212,209,208,0,0,200,201,0,0,0,200,201,0,0,0,0,
0,0,0,0,200,204,211,212,209,208,0,0,0,200,204,211,212,209,208,
0,0,0,0,200,204,211,212,209,208,0,0,200,204,211,212,209,208,0,
0,0,0,0,0,0,200,204,211,212,209,208,0,0,0,200,204,211,212,
209,208,0,0,0,200,204,211,212,209,208,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,200,0,0,0,0,0,200,204,202,205,206,
207,208,0,0,0,0,0,0,200,204,202,205,201,209,203,210,0,0,0,
0,200,201,0,0,0,0,0,200,204,202,205,206,207,208,0,0,0,0,
0,200,201,0,0,0,0,0,0,200,204,211,212,209,208,0,0,0,200,
204,211,212,209,208,0,0,0,200,204,211,212,209,208,0,0,0,0,0,
0,200,204,211,212,209,208,0,0,0,200,204,211,212,209,208,0,0,0,
200,204,211,212,209,208,0,0,0,0,0,0,0,0,0,0,200,0,0,
0,0,0,200,204,202,205,206,207,208,0,0,0,0,0,0,0,0,0,
200,204,211,212,209,208,0,0,0,200,214,205,206,203,0,0,0,200,204,
211,212,209,208,0,200,204,202,205,206,207,208,0,0,0,0,0,0,0,
0,0,200,204,211,212,209,208,0,0,0,200,204,211,212,209,208,0,0,
0,0,0,200,202,201,203,0,0,0,200,204,211,212,209,208,0,0,0,
0,0,0,0,200,204,211,212,209,208,0,0,0,200,204,211,212,209,208,
0,0,0,200,204,211,212,209,208,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,200,0,0,0,0,0,200,204,202,205,206,207,208,
0,0,0,0,0,0,200,213,204,202,211,212,201,209,207,208,210,0,0,
200,0,0,0,0,0,0,200,204,202,205,206,207,208,0,0,0,0,200,
201,0,0,0,0,0,0,200,204,211,212,209,208,0,0,0,200,204,211,
212,209,208,0,0,0,200,204,211,212,209,208,0,0,0,0,0,0,200,
204,211,212,209,208,0,0,0,200,204,211,212,209,208,0,0,0,200,204,
211,212,209,208,0,0,0,0,0,0,0,0,0,0,200,0,0,0,0,
0,0,200,204,202,205,206,207,208,0,0,0,0,0,0,0,0,200,204,
211,212,209,208,0,0,0,0,0,0,0,0,0,0,0,200,213,204,214,
202,211,205,212,206,209,207,203,208,210,0,0,0,0,0,0,0,0,0,
200,204,211,212,209,208,0,0,0,200,204,211,212,209,208,0,0,0,0,
0,0,0,0,0,0,0,0,200,204,211,212,209,208,0,0,0,0,0,
0,0,200,204,211,212,209,208,0,0,0,200,204,211,212,209,208,0,0,
0,200,204,211,212,209,208,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,200,0,0,0,0,0,0,200,204,202,205,206,207,208,0,
0,0,0,0,0,200,213,204,214,211,205,212,206,209,207,208,210,0,0,
0,0,0,0,0,200,204,202,205,206,207,208,0,0,0,0,200,201,0,
0,0,0,0,0,200,204,211,212,209,208,0,0,0,200,204,211,212,209,
208,0,0,0,200,204,211,212,209,208,0,0,0,0,0,0,200,204,211,
212,209,208,0,0,0,200,204,211,212,209,208,0,0,0,200,204,211,212,
209,208,0,0,0,0,0,0,0,0,0,200,213,204,214,202,211,205,212,
201,206,209,207,203,208,210,0,0,0,0,0,0,0,0,200,204,211,212,
209,208,0,0,0,0,0,0,0,0,0,0,0,200,204,211,212,209,208,
0,0,200,204,211,212,209,208,0,0,0,0,0,0,0,0,0,200,204,
211,212,209,208,0,0,0,200,204,211,212,209,208,0,0,0,0,0,200,
213,204,214,202,205,212,201,206,207,203,208,210,0,0,0,0,0,0,0,
200,204,211,212,209,208,0,0,0,200,204,211,212,209,208,0,0,0,200,
204,211,212,209,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,200,213,204,214,202,211,205,212,201,206,209,207,203,208,210,0,0,0,
0,0,0,0,200,213,204,214,211,205,212,206,209,207,208,210,0,0,0,
0,0,0,0,200,204,202,205,206,207,208,0,0,0,200,0,0,0,0,
0,0,0,200,204,211,212,209,208,0,0,0,200,204,211,212,209,208,0,
0,0,200,204,211,212,209,208,0,0,0,0,0,0,200,204,211,212,209,
208,0,0,0,200,204,211,212,209,208,0,0,0,200,204,211,212,209,208,
0,0,0,0,0,0,0,0,0,200,0,0,0,0,0,0,0,0,200,
204,202,205,206,207,208,0,0,0,0,0,0,0,200,204,211,212,209,208,
0,0,0,0,0,0,0,0,0,0,0,200,204,211,212,209,208,0,0,
0,200,204,211,212,209,208,0,0,0,0,0,0,0,0,200,204,211,212,
209,208,0,0,0,200,204,211,212,209,208,0,0,0,0,200,214,205,206,
203,0,0,0,200,204,211,212,209,208,0,0,0,0,0,0,0,200,204,
211,212,209,208,0,0,0,200,204,211,212,209,208,0,0,0,200,204,211,
212,209,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,
0,0,0,0,0,0,0,0,200,204,202,205,206,207,208,0,0,0,0,
200,0,0,0,200,213,204,202,211,212,201,209,207,208,210,0,0,0,0,
0,0,200,204,202,205,206,207,208,0,0,0,200,0,0,0,0,0,0,
0,200,204,211,212,209,208,0,0,0,200,204,211,212,209,208,0,0,0,
200,204,211,212,209,208,0,0,0,0,0,0,200,204,211,212,209,208,0,
0,0,200,204,211,212,209,208,0,0,0,200,204,211,212,209,208,0,0,
0,0,0,0,0,0,200,201,0,0,0,0,0,0,0,0,200,204,202,
205,206,207,208,0,0,0,0,0,0,0,200,204,211,212,209,208,0,0,
0,0,0,0,0,0,0,0,0,200,204,211,212,209,208,0,0,0,200,
204,211,212,209,208,0,0,0,0,0,0,0,0,200,204,211,212,209,208,
0,0,0,200,204,211,212,209,208,0,0,0,200,204,211,212,209,208,0,
0,0,200,204,211,212,209,208,0,0,0,0,0,0,0,200,204,211,212,
209,208,0,0,0,200,204,211,212,209,208,0,0,0,200,204,211,212,209,
208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,201,0,0,
0,0,0,0,0,0,200,204,202,205,206,207,208,0,0,0,0,200,0,
0,0,0,0,0,200,204,202,205,201,209,203,210,0,0,0,0,0,0,
0,200,204,202,205,206,207,208,0,200,201,0,0,0,0,0,0,0,200,
204,211,212,209,208,0,0,0,200,204,211,212,209,208,0,0,0,200,204,
211,212,209,208,0,0,0,0,0,0,200,204,211,212,209,208,0,0,0,
200,204,211,212,209,208,0,0,0,200,204,211,212,209,208,0,0,0,0,
0,0,0,0,200,201,0,0,0,0,0,0,0,0,0,200,204,202,205,
206,207,208,0,0,0,0,0,0,200,204,211,212,209,208,0,0,0,0,
0,0,0,0,0,0,0,200,204,211,212,209,208,0,0,0,0,200,204,
211,212,209,208,0,0,0,0,0,0,0,200,204,211,212,209,208,0,0,
0,200,204,211,212,209,208,0,0,0,200,204,211,212,209,208,0,0,0,
200,204,211,212,209,208,0,0,0,0,0,0,0,200,204,211,212,209,208,
0,0,0,200,204,211,212,209,208,0,0,0,200,204,211,212,209,208,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,200,201,0,0,0,0,
0,0,0,0,0,200,204,202,205,206,207,208,0,0,0,200,201,0,0,
0,0,0,0,200,204,202,205,206,207,208,0,0,0,0,0,0,0,200,
213,214,211,212,201,209,203,210,0,0,0,0,0,0,0,0,200,204,211,
212,209,208,0,0,0,200,204,211,212,209,208,0,0,0,200,204,211,212,
209,208,0,0,0,0,0,0,200,204,211,212,209,208,0,0,0,200,204,
211,212,209,208,0,0,0,200,204,211,212,209,208,0,0,0,0,0,0,
0,200,211,209,0,0,0,0,0,0,0,0,0,200,204,202,205,206,207,
208,0,0,0,0,0,0,200,204,211,212,209,208,0,0,0,0,0,0,
0,0,0,0,0,200,204,211,212,209,208,0,0,0,0,200,204,211,212,
209,208,0,0,0,0,0,0,0,200,204,211,212,209,208,0,0,0,200,
204,211,212,209,208,0,0,0,200,204,211,212,209,208,0,0,0,200,204,
211,212,209,208,0,0,0,0,0,0,0,200,204,211,212,209,208,0,0,
0,200,204,211,212,209,208,0,0,0,200,204,211,212,209,208,0,0,0,
0,0,0,0,0,0,0,0,0,0,200,211,209,0,0,0,0,0,0,
0,0,0,200,204,202,205,206,207,208,0,0,0,200,201,0,0,0,0,
0,0,200,204,202,205,206,207,208,0,0,0,0,0,0,0,0,200,204,
202,205,201,209,203,210,0,0,0,0,0,0,0,0,200,204,211,212,209,
208,0,0,0,200,204,211,212,209,208,0,0,0,200,204,211,212,209,208,
0,0,0,0,0,0,200,204,211,212,209,208,0,0,0,200,204,211,212,
209,208,0,0,0,200,204,211,212,209,208,0,0,0,0,0,0,0,200,
211,209,0,0,0,0,0,0,0,0,0,0,200,204,202,205,206,207,208,
0,0,0,0,0,200,204,211,212,209,208,0,0,0,0,0,0,0,0,
0,0,0,200,204,211,212,209,208,0,0,0,0,0,200,204,211,212,209,
208,0,0,0,0,0,0,200,204,211,212,209,208,0,0,0,200,204,211,
212,209,208,0,0,0,200,204,211,212,209,208,0,0,200,204,202,205,206,
207,208,0,0,200,0,0,0,0,200,204,211,212,209,208,0,0,0,200,
204,211,212,209,208,0,0,0,200,204,211,212,209,208,0,0,0,0,0,
0,0,0,0,0,0,0,0,200,211,209,0,0,0,0,0,0,0,0,
0,0,200,204,202,205,206,207,208,0,0,200,211,209,0,0,0,0,0,
200,204,211,212,209,208,0,0,0,0,0,0,0,0,0,200,204,202,205,
201,209,203,210,0,0,0,0,0,0,0,0,200,204,211,212,209,208,0,
0,0,200,204,211,212,209,208,0,200,204,202,205,201,209,203,210,0,0,
0,0,0,0,200,204,211,212,209,208,0,0,0,200,204,211,212,209,208,
0,0,0,200,204,211,212,209,208,0,0,0,0,0,0,200,214,205,206,
203,0,0,0,0,0,0,0,0,0,200,204,202,205,206,207,208,0,0,
0,0,200,204,202,205,201,209,203,210,0,0,0,0,0,0,0,0,0,
0,200,204,202,205,206,207,208,0,0,0,200,204,202,205,201,209,203,210,
0,0,0,0,200,204,202,205,201,209,203,210,0,200,204,202,205,201,209,
203,210,0,0,0,200,204,202,205,206,207,208,0,200,213,214,211,212,201,
209,203,210,0,0,0,200,204,202,205,201,209,203,210,0,200,204,202,205,
201,209,203,210,0,200,204,202,205,201,209,203,210,0,0,0,0,0,0,
0,0,0,0,0,200,214,205,206,203,0,0,0,0,0,0,0,0,0,
200,204,202,205,206,207,208,0,0,200,214,205,206,203,0,0,200,214,205,
206,203,0,0,0,0,0,0,0,0,0,0,0,0,200,204,202,205,206,
207,208,0,0,0,0,0,0,0,200,204,202,205,201,209,203,210,0,0,
200,204,202,205,206,207,208,0,0,200,204,202,205,206,207,208,0,0,0,
0,200,204,202,205,201,209,203,210,0,200,204,202,205,201,209,203,210,0,
200,204,202,205,201,209,203,210,0,0,0,200,213,214,211,212,201,209,203,
210,0,0,0,0,0,200,213,214,202,205,212,206,207,203,210,0,200,213,
204,214,211,205,212,206,209,207,208,210,0,0,0,0,0,0,0,200,213,
214,211,212,201,209,203,210,0,200,213,204,202,211,212,201,209,207,208,210,
0,200,213,214,211,212,201,209,203,210,0,200,213,214,211,212,201,209,203,
210,0,0,0,200,214,205,206,203,0,0,0,200,204,202,205,206,207,208,
0,0,200,213,214,202,205,212,206,207,203,210,0,200,204,202,205,201,209,
203,210,0,200,213,214,211,212,201,209,203,210,0,0,0,0,0,0,0,
0,200,213,214,211,212,201,209,203,210,0,0,0,0,0,200,213,214,202,
205,212,206,207,203,210,0,200,0,0,0,200,204,211,212,209,208,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,202,201,203,0,
0,0,0,0,0,200,213,204,202,211,212,201,209,207,208,210,0,0,200,
211,209,0,0,0,0,0,200,204,202,205,201,209,203,210,0,200,213,214,
202,205,212,206,207,203,210,0,200,204,202,205,201,209,203,210,0,200,213,
214,211,212,201,209,203,210,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,200,211,209,0,0,0,0,0,0,200,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,200,214,205,206,203,0,0,0,0,200,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,200,204,211,212,209,208,0,0,0,200,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
200,214,205,206,203,0,0,200,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,
204,202,205,206,207,208,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 );

PicPalette : Array[1..23*4] Of Byte =
(200,63,10,10,
213,61,10,10,
204,59,10,10,
214,57,10,10,
202,55,10,10,
211,53,10,10,
205,51,10,10,
212,49,10,10,
201,47,10,10,
206,45,10,10,
209,43,10,10,
207,41,10,10,
203,39,10,10,
208,37,10,10,
210,35,10,10,
CharColor,63,63,0,
CharColor+1,57,57,0,
CharColor+2,51,51,0,
CharColor+3,45,45,0,
CharColor+4,39,39,0,
CharColor+5,33,33,0,
CharColor+6,27,27,0,
CharColor+7,21,21,0  );

NumColors = 23;

  Type  GridType = Array[1..RecLength*RecWidth*3] Of Byte;
        PalettePtr = ^PaletteRec;
        PaletteRec = Record
          GridPalette : GridType;
          Up,
          Down,
          Left,
          Right : PalettePtr;
        End;

        PathType = Array[1..NumSteps] Of Word;
        PathPtr = ^PathRec;
        PathRec = Record
          PicPath : PathType;
          Next    : PathPtr;
        End;

  Var   PaletteHead,
        CurrentPtr  : PalettePtr;
        CurrInstr : Integer;

        PathHead,
        CurrPath  : PathPtr;
        Path : PathType;

        KeyHit : Boolean;
        Int9Vec : LongInt;

        CurrPicPos : Word;
        Direction : Boolean;

        DispChars   : Array[1..NumDispChars*64] Of Byte;
        CurrentLine : Word;

        RGB_Components : Array[1..3] Of Byte;
        All_RGB : Array[1..256*3] Of Byte;

  Procedure VideoMode ( Mode : Byte );

    Begin { VideoMode }
      Asm
        Mov  AH,00
        Mov  AL,Mode
        Int  10h
      End;
    End;  { VideoMode }


  Procedure CreatePalettePtrs;

{ Argh!  Even MORE processor time! and eats up a lot of space! }
{ The pointer data structure is a 4D torus }

    Procedure Create4DTorus;

      Var CurrPtr,
          NewPtr,
          StartPtr,
          PrevLinePtr,
          PrevLineCurrPtr : PalettePtr;
  
          YCount,
          XCount : Integer;
  
      Begin { Create4DTorus }
        PaletteHead := Nil;
        PrevLinePtr := Nil;
        For YCount := 1 To RecLength Do
          Begin
            StartPtr := Nil;
            CurrPtr := Nil;
            PrevLineCurrPtr := PrevLinePtr;
            For XCount := 1 To RecLength Do
              Begin
                New(NewPtr);
                If PaletteHead = Nil Then PaletteHead := NewPtr;
                If StartPtr = Nil Then StartPtr := NewPtr;
                If CurrPtr = Nil
                  Then CurrPtr := NewPtr
                  Else Begin
                    CurrPtr^.Right := NewPtr;
                    NewPtr^.Left := CurrPtr;
                  End;
                CurrPtr := NewPtr;
                If PrevLinePtr = Nil
                  Then PrevLinePtr := NewPtr
                  Else If PrevLineCurrPtr <> Nil
                    Then Begin
                      CurrPtr^.Up := PrevLineCurrPtr;
                      PrevLineCurrPtr^.Down := CurrPtr;
                      PrevLineCurrPtr := PrevLineCurrPtr^.Right;
                    End;
              End;
            CurrPtr^.Right := StartPtr;
            StartPtr^.Left := CurrPtr;
            PrevLinePtr := StartPtr;
          End;
        CurrPtr := StartPtr;
        PrevLineCurrPtr := PaletteHead;
        For XCount := 1 To RecLength Do
          Begin
            CurrPtr^.Down := PrevLineCurrPtr;
            PrevLineCurrPtr^.Up := CurrPtr;
            CurrPtr := CurrPtr^.Right;
            PrevLineCurrPtr := PrevLineCurrPtr^.Right;
          End;
      End;  { Create4DTorus }


      Function GoodCol ( Num : Integer ) : Integer;

        Begin { GoodCol }
          If Num > RecLength
            Then GoodCol := Num-RecLength
            Else If Num < 1
              Then GoodCol := Num + RecLength
              Else GoodCol := Num;
        End;  { GoodCol }


    Var CurrPtr : PalettePtr;
        Count,
        Count2,
        Count3,
        YCount,
        XCount,
        CopyTo,
        AnyCol  : Integer;

        SmallGrid : Array[1..RecLength,1..RecWidth] Of Boolean;

    Begin { CreatePalettePtrs }
      Create4DTorus;
      CurrPtr := PaletteHead;
      For YCount := 1 To RecLength Do
        Begin
          If YCount <= RecWidth
            Then Begin
              For Count := 1 To RecWidth-YCount Do
                For Count2 := 1 To RecLength Div 2 Do
                  Begin
                    SmallGrid[Count2,Count] := True;
                    SmallGrid[RecLength Div 2 + Count2,Count] := False;
                  End;
              For Count := RecWidth-YCount+1 To RecWidth Do
                For Count2 := 1 To RecLength Div 2 Do
                  Begin
                    SmallGrid[Count2,Count] := False;
                    SmallGrid[RecLength Div 2 + Count2,Count] := True;
                  End
            End
            Else Begin
              For Count := 1 To RecWidth-YCount+8 Do
                For Count2 := 1 To RecLength Div 2 Do
                  Begin
                    SmallGrid[Count2,Count] := False;
                    SmallGrid[RecLength Div 2 + Count2,Count] := True;
                  End;
              For Count := RecWidth-YCount+9 To RecWidth Do
                For Count2 := 1 To RecLength Div 2 Do
                  Begin
                    SmallGrid[Count2,Count] := True;
                    SmallGrid[RecLength Div 2 + Count2,Count] := False;
                  End;
            End;
          For XCount := 1 To RecLength Do
            Begin
              AnyCol := GoodCol(XCount-1);
              For Count := 1 To RecWidth Do
                SmallGrid[XCount,Count] := SmallGrid[AnyCol,Count];
              AnyCol := GoodCol(XCount+RecLength Div 2 - 1);
              CopyTo := GoodCol(AnyCol+1);
              For Count := 1 To RecWidth Do
                SmallGrid[CopyTo,Count] := SmallGrid[AnyCol,Count];
              For Count := 1 To RecWidth Do
                For Count2 := 1 To RecLength Do
                  If SmallGrid[Count2,Count]
                    Then For Count3 := 1 To 3 Do
                      CurrPtr^.GridPalette[(Count-1)*RecLength*3+(Count2-1)*3 + Count3]
                                                                  := FirstColor[Count3]
                    Else For Count3 := 1 To 3 Do
                      CurrPtr^.GridPalette[(Count-1)*RecLength*3+(Count2-1)*3 + Count3]
                                                                  := SecondColor[Count3];
              CurrPtr := CurrPtr^.Right;
            End;
          CurrPtr := CurrPtr^.Down;
        End;
    End;  { CreatePalettePtrs }


  Procedure CalcPicPath;

    Var Count,
        Step    : Integer;
        NewPtr,
        PrevPtr : PathPtr; 

    Begin { CalcPicPath }
      PathHead := Nil;
      For Count := 0 To 5 Do
        Begin
          New(NewPtr);
          If PathHead = Nil
            Then PathHead := NewPtr
            Else PrevPtr^.Next := NewPtr;
          PrevPtr := NewPtr;
          For Step := 1 To NumSteps Do
            NewPtr^.PicPath[Step] := Round((3+Count)*Sin(Count*Step*AngleStep));
        End;
      For Count := 4 Downto 0 Do
        Begin
          New(NewPtr);
          PrevPtr^.Next := NewPtr;
          PrevPtr := NewPtr;
          For Step := 1 To NumSteps Do
            NewPtr^.PicPath[Step] := Round((3+Count)*Sin(Count*Step*AngleStep));
        End;
      NewPtr^.Next := PathHead;
    End;  { CalcPicPath }


  Procedure DrawGrid;

    Type ColorRec = Array[1..RecLength,1..RecWidth] Of Byte;

    Var  RegRec,
         IncRec  : ColorRec;

    Function Slope ( StartX,StartY,EndX,EndY : Integer ) : Real;

      Begin { Slope }
        Slope := (StartY-EndY) / (StartX-EndX);
      End;  { Slope }


    Procedure FillSpaces ( Var XPos : Integer; YPos,Spaces,Line,Height : Integer; RecType : Boolean );

      Var RecYLoc,
          Count : Integer;

          Rec : ColorRec;

      Begin { FillSpaces }
        If RecType
          Then Rec := RegRec
          Else Rec := IncRec;
        RecYLoc := Trunc((Line-1)*RecWidth/Height) + 1;
        Count := 1;
        While (Count <= Spaces) And (XPos <= 320) Do
          Begin
            Mem[VGA_Segment:(YPos-1)*320+XPos-1] := Rec[Trunc((Count-1)*RecLength/Spaces)+1,RecYLoc];
            Inc(XPos);
            Inc(Count);
          End;
      End;  { FillSpaces }


    Var YCount,
        XCount,
        XPoint1,
        XPoint2,
        ZeroXPos,
        SpaceBetween,
        LineNum,
        Height : Integer;

        Regular : Boolean;

        TempValue : Byte;

    Begin { DrawGrid }
      For YCount := 1 To RecWidth Do
        For XCount := 1 To RecLength Do
          Begin
            RegRec[XCount,YCount] := (YCount-1)*RecLength + XCount;
            If XCount > RecWidth
              Then IncRec[XCount,YCount] := (YCount-1)*RecLength + XCount - RecWidth
              Else IncRec[XCount,YCount] := (YCount-1)*RecLength + XCount + RecWidth;
          End;
      Height := StartHeight;
      LineNum := 1;
      Regular := True;
      For YCount := 1 To GridHeight Do
        Begin
          ZeroXPos := 160;
          XCount := 160;
          While XCount <= 320 Do
            Begin
              If XCount = 160
{ Argh! }       Then XPoint1 := 160
{ Processor }   Else XPoint1 := Round(YCount/
{ time!!!!! }     Slope(PerspPointXPos,PerspPointYPos,ZeroXPos,1)) + ZeroXPos;
              XPoint2 := Round(YCount/
                  Slope(PerspPointXPos,PerspPointYPos,ZeroXPos+LineLength,1)) + ZeroXPos+LineLength;
              SpaceBetween := XPoint2 - XPoint1;
              FillSpaces(XCount,YCount,SpaceBetween,LineNum,Height,Regular);
              ZeroXPos := ZeroXPos + LineLength;
            End;
          Inc(LineNum);
          If LineNum > Height
            Then Begin
              LineNum := 1;
              Height := Round(Height * 0.75);
              Regular := Not Regular;
            End;
        End;
      For YCount := 1 To GridHeight Do
        For XCount := 161 To 320 Do
          Begin
            TempValue := Mem[VGA_Segment:(YCount-1)*320+XCount-1];
            Mem[VGA_Segment:(YCount-1)*320+320-XCount] := (((TempValue-1) Div RecLength)+1)*RecLength
                                                                       - ((TempValue-1) Mod RecLength);
          End;
      For YCount := 1 To GridHeight Do
        Move(Mem[VGA_Segment:(YCount-1)*320],Mem[VGA_Segment:(200-YCount)*320],320);
    End;  { DrawGrid }


  Procedure SetPaletteZero;

    Label PalLoop;

    Begin { SetPaletteZero }
      Asm
        MOV     DX,03C8h
        XOR     AL,AL
        OUT     DX,AL
        INC     DX
        MOV     CX,256*3

PalLoop:
        OUT     DX,AL
        LOOP    PalLoop
      End;
    End;  { SetPaletteZero }


  Procedure ShowPaletteAndPic ( Var Pal : PaletteRec );

    Label Wait,Retr,PlacePicLoop,GoUp,BlankLoop,Continue5,Continue6,
          PlaceTextLoop,BottomSide,BackIn,BottomSideSlice;
{* TheEnd,BottomSideSlice2nd *}

    Var Temp1,
        Temp2,
        DataSeg : Word;

    Begin { ShowPaletteAndPic }
      Asm

        MOV     SI,OFFSET Picture
        MOV     AX,VGA_Segment
        MOV     ES,AX

        MOV     BX,PicYPos-2
        ADD     BX,CurrPicPos
        PUSH    BX
        SHL     BX,8
        POP     AX
        SHL     AX,6
        ADD     AX,BX
        MOV     DI,AX

        PUSH    ES
        PUSH    SI
        PUSH    DI

        PUSH    DS
        LDS     SI,Pal

        MOV     DX,3DAh
Wait:   IN      AL,DX
        TEST    AL,08h
        JZ      Wait
Retr:   IN      AL,DX
        TEST    AL,08h
        JNZ     Retr

{* Put current palette in *}

        MOV     DX,03C8h
        MOV     AL,01h
        OUT     DX,AL
        INC     DX
        CLD
        MOV     CX,RecLength*RecWidth*3
        REP     OUTSB
        POP     DS

{* Put picture on screen *}


        POP     DI
        POP     SI
        POP     ES

        PUSH    DI
        MOV     CX,PicYLen*160
        XOR     AX,AX
        REP     STOSW
        POP     DI

        ADD     DI,320+PicXPos
        MOV     DX,PicYLen
        MOV     BX,CurrPicPos
        SHL     BX,1
PlacePicLoop:
        MOV     AX,Word Ptr Path[BX]
        ADD     DI,AX
        MOV     CX,PicXLen
        REP     MOVSB
        ADD     DI,320-PicXLen
        SUB     DI,AX
        INC     BX
        INC     BX
        DEC     DX
        JNZ     PlacePicLoop


        PUSH    DS
        MOV     AX,VGA_Segment
        MOV     DS,AX

        MOV   DX,8
        MOV   DI,320*TextYPos
        MOV   SI,320*TextYPos+1

BottomSide:
        MOV   CX,319
        REP   MOVSB
        INC   DI
        INC   DI
        INC   SI
        INC   SI
        DEC   DX
        JNZ   BottomSide

        POP   DS
        MOV   BX,CurrentLine
        INC   CurrentLine
{        INC   CurrentLine }
        CMP   Word Ptr CurrentLine,(NumDispChars-1)*8 - 1
        JNG   BackIn
        MOV   CurrentLine,0
BackIn:
        SHL   BX,1
        SHL   BX,1
        SHL   BX,1
        MOV   SI,OFFSET DispChars
        ADD   SI,BX

        MOV   CX,8
        MOV   DI,320*TextYPos+319
BottomSideSlice:
        MOVSB
        ADD   DI,319
        LOOP  BottomSideSlice

{        MOV   CX,8
        MOV   DI,320*TextYPos+319
BottomSideSlice2nd:
        MOVSB
        ADD   DI,319
        LOOP  BottomSideSlice2nd
 }

        CMP     CurrPicPos,NumSteps-PicYLen
        JNE     Continue5
        INC     Direction

Continue5:
        CMP     Direction,1
        JE      GoUp
        INC     CurrPicPos
        JMP     Continue6

GoUp:
        DEC     CurrPicPos


{*****
Continue6:
        INC     CurrInstr
        CMP     CurrInstr,NumInstr
        JLE     TheEnd
        MOV     CurrInstr,1
*****}


{
TheEnd:
}
{*} Continue6:
      End;
    End;  { ShowPaletteAndPic }


  Procedure SetInt9 ( I9Seg,I9Ofs : Word );

    Begin { SetInt9 }
      Asm
        PUSH    DS

        MOV     AH,35h
        MOV     AL,09h
        INT     21h
        MOV     Word Ptr Int9Vec,BX
        MOV     Word Ptr Int9Vec[2],ES

        MOV     AX,I9Seg
        MOV     DS,AX
        MOV     DX,I9Ofs
        MOV     AH,25h
        MOV     AL,09h
        INT     21h

        POP     DS
      End;
    End;  { SetInt9 }


  Procedure DisInt9;

    Begin { DisInt9 }
      Asm
        PUSH    DS
        MOV     DX,Word Ptr Int9Vec
        MOV     AX,Word Ptr Int9Vec[2]
        MOV     DS,AX
        MOV     AH,25h
        MOV     AL,09h
        INT     21h
        POP     DS
      End;
    End;  { DisInt9 }


  Procedure Int9;

  Interrupt;

    Begin { Int9 }
      Asm
        PUSHF
        CALL    Int9Vec
        INC     KeyHit
      End;
    End;  { Int9 }


    Procedure InitPalette;

      Label PalLoop;

      Begin { InitPalette }
        Asm
          MOV     SI,OFFSET PicPalette
          MOV     CX,NumColors
          MOV     DX,3C8h
          CLD

PalLoop:
          OUTSB
          INC     DX
          OUTSB
          OUTSB
          OUTSB
          DEC     DX
          LOOP    PalLoop
        End;
      End;  { InitPalette }


  Procedure BuildCharArray;

    Var ShearYCnt,
        ShearXCnt,
        Count,
        ArrayPtr   : Integer;
        TempByte   : Byte;

    Begin { BuildCharArray }
      ArrayPtr := 1;
      For Count := 1 To NumDispChars Do
        Begin
          For ShearXCnt := 1 To 8 Do
            For ShearYCnt := 1 To 8 Do
              Begin
                If Mem[CGA_CharSet_Seg:CGA_CharSet_Ofs+Ord(DispStr[Count])*8+ShearYCnt-1] And ($80 Shr (ShearXCnt-1)) = 0
                  Then DispChars[ArrayPtr] := 0
                  Else DispChars[ArrayPtr] := CharColor-1+ShearYCnt;
                Inc(ArrayPtr);
              End;
        End;
    End;  { BuildCharArray }


  Procedure FadeOut;

    Label OneCycle,ReadLoop,DecLoop,Continue,Retr,Wait,Retr2,Wait2;

    Begin { FadeOut }
      Asm
        MOV   CX,64
OneCycle:

        MOV     DX,3DAh
Wait:   IN      AL,DX
        TEST    AL,08h
        JZ      Wait
Retr:   IN      AL,DX
        TEST    AL,08h
        JNZ     Retr

        MOV   DX,03C7h
        XOR   AL,AL
        OUT   DX,AL
        INC   DX
        INC   DX
        XOR   BX,BX
ReadLoop:
        IN    AL,DX
        MOV   Byte Ptr All_RGB[BX],AL
        INC   BX
        CMP   BX,256*3
        JL    ReadLoop

        XOR   BX,BX
DecLoop:        
        CMP   Byte Ptr All_RGB[BX],0
        JE    Continue
        DEC   Byte Ptr All_RGB[BX]

Continue:
        INC   BX
        CMP   BX,256*3
        JL    DecLoop

        MOV     DX,3DAh
Wait2:   IN      AL,DX
        TEST    AL,08h
        JZ      Wait2
Retr2:   IN      AL,DX
        TEST    AL,08h
        JNZ     Retr2

        MOV   DX,03C8h
        MOV   AL,0
        OUT   DX,AL
        INC   DX
        MOV   SI,OFFSET All_RGB
        CLD
        PUSH  CX
        MOV   CX,256*3
        REP   OUTSB
        POP   CX

        LOOP  OneCycle

      End;
    End; { FadeOut }


  Begin { Grid3D }
    CreatePalettePtrs;  {* Messy procedure here, but overhead only... *}
    CalcPicPath;

    BuildCharArray;

    VideoMode($13);

    SetInt9 (Seg(Int9),Ofs(Int9));

    KeyHit := False;

    SetPaletteZero;
    DrawGrid;
    InitPalette;

    CurrentLine := 0;
    CurrPath := PathHead^.Next^.Next^.Next^.Next^.Next;
    Path := CurrPath^.PicPath;
    Direction := False;
    CurrPicPos := 0;
    CurrInstr := 1;
    CurrentPtr := PaletteHead;
    Repeat
      CurrentPtr := CurrentPtr^.Down^.Right;


{*****
      Case Instructions[CurrInstr] Of
        1 : CurrentPtr := CurrentPtr^.Up;
        2 : CurrentPtr := CurrentPtr^.Up^.Right;
        3 : CurrentPtr := CurrentPtr^.Right;
        4 : CurrentPtr := CurrentPtr^.Down^.Right;
        5 : CurrentPtr := CurrentPtr^.Down;
        6 : CurrentPtr := CurrentPtr^.Down^.Left;
        7 : CurrentPtr := CurrentPtr^.Left;
        8 : CurrentPtr := CurrentPtr^.Up^.Left;
      End;
*****}


      ShowPaletteAndPic(CurrentPtr^);
      If CurrPicPos = 0
        Then Begin
          Direction := False;
          CurrPath := CurrPath^.Next;
          Path := CurrPath^.PicPath;
        End;
    Until KeyHit;
    FadeOut;
    DisInt9;
    VideoMode($03);
  End.  { Grid3D }
