	LOCALS @@
_TEXT	segment byte public 'CODE'
_TEXT	ends
	assume	cs:_TEXT, ds:_TEXT

include ultramid.inc
riff_header struc
	rh_RIFF dd ?
	rh_file_size dd ?
	rh_WAVE dd ?
	rh_fmt dd ?
	rh_format_size dd ?
riff_header ends

format_header struc
	fh_wFormatTag dw ?
	fh_nChannels dw ?
	fh_nSamplesPerSec dd ?
	fh_nAvgBytesPerSec dd ?
	fh_nBlockAlign dw ?
	fh_nBitsPerSample dw ?
format_header ends

data_header struc
	dh_DATA dd ?
	dh_size dd ?
data_header ends

_TEXT	segment byte public 'CODE'
	org 100h
start:	call _main
	mov ah,4ch
	int 21h

__psp	dw ?
_um_hook	label	dword
_hookoff	dw	0
_hookseg dw	0
_volume	dw	4095
_pan	dw	7
_paused  db	0
_user_request_stop	db	0

_head_keys	label	dword
	dw	1ah
	dw	40h
_tail_keys	label	dword
	dw	1ch
	dw	40h

_umss um_sound_struct <>
chk_hook_str db 'ULTRAMID',0
riffheader riff_header <>
formatheader format_header <>
dataheader data_header <>

BS_EMPTY equ 0
BS_FILLED equ 1
BS_XFERRED equ 2
BS_PLAYING equ 3
NBUFFS equ 10
BSIZE equ 4096
BSIZE_BITS equ 12

_um_callback proc	C far,reason,voice,buff:FAR PTR,bufflen:FAR PTR, bufrate:FAR PTR
	uses ds, si, di 

 	mov	ax, cs
 	mov	ds, ax

	mov	ax,reason
	cmp	ax,UM_STOP_SOUND
	je	short @@stop
	cmp	ax,UM_MORE_DATA
	je	short @@more_data
	cmp	ax,UM_VOICE_DONE
	je	short @@voice_done
	mov	ax, 0
	jmp	@@ret
@@stop:
	mov	_still_playing,0
	jmp	@@ret
@@more_data:
	mov	bx,_dma_index
	mov	ax, 0
	cmp	_buff_status[bx],BS_FILLED
	jne	short @@ret
	mov	cl,BSIZE_BITS ; find addr of buffer (_dma_index * BSIZE + offset(buffs))
	shl	bx,cl
	add	bx,offset _buffs
	; fill in buff with next buffer to play
	les	si,buff
	mov	word ptr es:[si+2],ds
	mov	word ptr es:[si],bx
	; fill in bufflen with size of next buffer to play
	mov	bx,_dma_index
	mov	cl,2
	shl	bx,cl
	mov	ax,_buff_len[bx+2]
	mov	dx,_buff_len[bx]
	les	bx,bufflen
	mov	word ptr es:[bx+2],ax
	mov	word ptr es:[bx],dx
	; fill in rate with frequency of next buffer
	les	bx,bufrate
	mov	ax,_frequency
	mov	word ptr es:[bx],ax
	; change status of _buff_status to BS_XFERRED
	mov	bx,_dma_index
	mov	byte ptr _buff_status[bx],BS_XFERRED
	; bump _dma_index
	mov	ax,bx
	inc	ax
	mov	bx,NBUFFS
	cwd	
	idiv	bx
	mov	word ptr _dma_index,dx
	mov	ax,1
	jmp	@@ret
@@voice_done:
	mov	bx,_play_index
	mov	_buff_status[bx],BS_EMPTY
	; bump _play_index
	mov	ax,_play_index
	inc	ax
	mov	dx, 0
	mov	cx,NBUFFS
	idiv	cx
	mov	_play_index,dx
	; if buffer was xferred already change status to BS_PLAY
	mov	bx, dx
	cmp	_buff_status[bx],BS_XFERRED
	jne	short @@ret
	mov	_buff_status[bx],BS_PLAYING
@@ret:
	ret	
_um_callback	endp

_my_strncmp	proc	C near, str1:NEAR PTR, str2:NEAR PTR, len:word
	uses ds, si, di
     	cld	
	mov	ax, cs
	mov	es, ax
     	mov	di, str2
     	mov	si, di
     	mov	ax, len
     	mov	cx, ax
	jcxz	short @@done
     	mov	bx, ax
     	xor	al, al
     	repne   scasb	
     	sub	bx, cx
     	mov	cx, bx
     	mov	di, si
     	mov	si, str1
     	repe    cmpsb	
     	mov	al, [si-1]
     	mov	bl, es:[di-1]
     	xor	ah, ah 
     	mov	bh, ah
     	sub	ax, bx

@@done:
	ret	
_my_strncmp	endp

_myputs	proc	C near string:NEAR PTR
	uses si
	mov	si,string
	jmp	short @@end_while
@@while:
	mov	bh,0
	mov	al, [si]
	mov	ah,14
	int	10h
	inc	si
@@end_while:
	cmp	byte ptr [si],0
	jne	short @@while
	ret	
_myputs	endp

_mygetch	proc	C near
	mov	ax,700h
	int	21h
	xor	ah,ah
	ret	
_mygetch	endp

_my_open	proc	C near fname:NEAR PTR
	mov	dx,fname
	mov	ah,03dh
	mov	al,0
	int	21h
	jnc	short @@ret
	mov	ax,-1
@@ret:
	ret	
_my_open	endp

_my_close	proc	C near handle
	mov	bx, handle
	mov	ah,3eh
	int	21h
	ret	
_my_close	endp

_my_read	proc	C near handle, buff, bsize
	mov	dx,buff
	mov	bx,handle
	mov	cx,bsize
	mov	ah,3fh
	int	21h
	jc	short @@ret
	mov	ax, 1
	jmp	short @@ret1
@@ret:
	xor	ax, ax
@@ret1:	ret	
_my_read	endp

_check_buffers	proc	C near fp, blength:NEAR ptr
	local bsize, c
	uses	si, di

	; check the keyboard
	les	bx,_head_keys
	mov	ax, word ptr es:[bx]
	les	bx,_tail_keys
	cmp	ax,word ptr es:[bx]
	jne	@@check_key
	jmp	@@check_buffers
@@check_key:
	call	_mygetch C
	mov	si,ax
	cmp	ax,27	; check esc key
	jne	short @@check_key_1
	mov	_user_request_stop,1
	mov	ax, TSR_STOP_DIGITAL
	mov	cx, _voice
	call	dword ptr _um_hook
	jmp	@@ret
@@check_key_1:
	cmp	si,'P'
	je	short @@p_pressed
	cmp	si,'p'
	jne	short @@check_key_2
@@p_pressed:
	cmp	_paused,0
	je	@@pause
	mov	ax, TSR_RESTART_DIGITAL
	mov	cx, _voice
	call	dword ptr _um_hook
	jmp	short @@flip_paused
@@pause:
	mov	ax, TSR_PAUSE_DIGITAL
	mov	cx, _voice
	call	dword ptr _um_hook
@@flip_paused:
	xor	_paused,1
	jmp	@@check_buffers
@@check_key_2:
	cmp	si,'>'
	jne	short @@check_key_3
	cmp	_pan,0
	jle	short @@check_key_3
	dec	_pan
@@set_pan:
	mov	bx,_pan
	mov	cx,_voice
	mov	ax, TSR_SET_PAN
	call	dword ptr _um_hook
	jmp	short @@check_buffers
@@check_key_3:
	cmp	si,'<'
	jne	short @@check_key_4
	cmp	_pan,15
	jge	short @@check_key_4
	inc	_pan
	jmp	short @@set_pan
@@check_key_4:
	cmp	si,','
	jne	short @@check_key_5
	sub	_volume,50
	jnc	@@set_volume
	mov	_volume,0
@@set_volume:
	mov	bx, _volume
	mov	cx, _voice
	mov	ax, TSR_SET_VOLUME
	call	dword ptr _um_hook
	jmp	short @@check_buffers
@@check_key_5:
	cmp	si,'.'
	jne	short @@check_buffers
	add	_volume,50
	cmp	_volume,4095
	jle	short @@set_volume
	mov	_volume,4095
	jmp	short @@set_volume
@@check_buffers:
	mov	di, word ptr [blength]
	jmp	@@end_while
@@while:
	; check if next buffer is empty
	mov	ax,word ptr [di]
	or	ax,word ptr [di+2]
	jne	short @@fill_buffer
	jmp	@@ret
@@fill_buffer:
	; bsize = MIN(BSIZE, blength)
	cmp	word ptr [di+2],0
	ja	short @@use_BSIZE
	cmp	word ptr [di],BSIZE
	jbe	short @@use_size
@@use_BSIZE:
	mov	si,BSIZE
	jmp	short @@do_read
@@use_size:
	mov	si,word ptr [di]
@@do_read:
	mov	ax,_fill_index
	mov	cl,BSIZE_BITS
	shl	ax,cl
	add	ax,offset _buffs
	call	_my_read C, fp, ax, si
	sub	word ptr [di],si
	sbb	word ptr [di+2],0
	mov	bx,_fill_index
	mov	cl,2
	shl	bx,cl
	mov	word ptr _buff_len[bx+2],0
	mov	word ptr _buff_len[bx],si
	mov	bx,_fill_index
	mov	_buff_status[bx],BS_FILLED
	mov	ax,bx
	inc	ax
	mov	bx,NBUFFS
	cwd	
	idiv	bx
	mov	_fill_index,dx
@@end_while:
	mov	bx,_fill_index
	cmp	_buff_status[bx],BS_EMPTY
	jne	@@ret
	jmp	@@while
@@ret:	ret	
_check_buffers	endp

_play	proc	C near filename:NEAR PTR, gf1mem:dword
	local fp, i, blength:dword, btype
	uses si, di

	mov	btype, 0
	call	_my_open C,[filename]
	mov	fp, ax
	cmp	ax, -1
	jne	short @@get_riff_header
	mov	ax,offset msg_cant_open
	call	_myputs C,ax
	call	_myputs C,[filename]
	mov	ax,offset msg_cant_open1
	call	_myputs C,ax
	jmp	@@ret
@@get_riff_header:
	mov	ax, offset riffheader
	mov	cx, size riffheader
	call	_my_read C, fp, ax, cx
	mov	bx, offset riffheader.rh_RIFF
	mov	cx, offset msg_RIFF
	call	_my_strncmp C, bx, cx, 4
	or	ax,ax
	je	@@2
	jmp	@@not_wav
@@2:
	lea	bx, riffheader.rh_WAVE
	lea	cx, msg_WAVE
	mov	ax,4
	call	_my_strncmp C, bx, cx, 4
	or	ax,ax
	je	@@3
	jmp	@@not_wav
@@3:
	lea	bx, riffheader.rh_fmt
	lea	cx, msg_fmt
	mov	ax,4
	call	_my_strncmp C, bx, cx, 4
	or	ax,ax
	je	@@4
	jmp	@@not_wav
@@4:
	mov	bx, word ptr riffheader.rh_format_size
	mov	ax, offset formatheader
	call	_my_read C, fp, ax, bx
	cmp	ax,1
	je	short @@check_tag
@@not_wav:
	mov	ax, offset msg_File
	call	_myputs C, ax
	call	_myputs C, filename
	mov	ax, offset msg_isnt_wave
	call	_myputs C, ax
@@close:
	call	_my_close C, fp
	jmp	@@ret
@@check_tag:
	cmp	word ptr formatheader.fh_wFormatTag,1
	je	short @@check_nchannels
	mov	ax, offset msg_cant_play
	call	_myputs C, ax
	call	_myputs C, filename
	jmp	short @@close
@@check_nchannels:
	cmp	word ptr formatheader.fh_nChannels,1
	je	@@check_nbits
	or	btype, UM_STEREO
@@check_nbits:
	cmp	word ptr formatheader.fh_nBitsPerSample,8
	jne	short @@check_16bits
	or	btype, (UM_8BIT OR UM_INVERT_MSB)
	jmp	short @@get_frequency
@@check_16bits:
	cmp	word ptr formatheader.fh_nBitsPerSample,16
	je	short @@get_frequency
	mov	ax, offset msg_cant_play
	call	_myputs C, ax
	call	_myputs C, filename
	mov	ax, offset msg_bad_type
	call	_myputs C, ax
	jmp	short @@close
@@get_frequency:
	mov	ax,word ptr formatheader.fh_nSamplesPerSec
	mov	word ptr _frequency,ax
	mov	ax, offset dataheader
	mov	bx, size dataheader
	call	_my_read C, fp, ax, bx
	lea	bx, dataheader.dh_DATA
	mov	ax, offset msg_data
	call	_my_strncmp C, bx, ax, 4
	or	ax,ax
	je	short @@get_length
	mov	ax, offset msg_cant_play
	call	_myputs C, ax
	call	_myputs C, filename
	mov	ax, offset msg_no_data
	call	_myputs C, ax
	jmp	@@close
@@get_length:
	mov	ax,word ptr dataheader.dh_size+2
	mov	dx,word ptr dataheader.dh_size
	mov	word ptr [blength+2],ax
	mov	word ptr [blength],dx
	mov	_user_request_stop,0
	mov	_umss.um_stereo_mem_seg,ds
	mov	_umss.um_stereo_mem_off,offset _stbuff
	mov	ax,word ptr [gf1mem+2]
	mov	dx,word ptr [gf1mem]
	mov	word ptr _umss.um_gf1mem+2,ax
	mov	word ptr _umss.um_gf1mem,dx
	mov	al,byte ptr _pan
	mov	byte ptr _umss.um_pan,al
	mov	ax,word ptr _volume
	mov	word ptr _umss.um_volume,ax
	mov	ax,word ptr _frequency
	mov	word ptr _umss.um_sample_rate,ax
	mov	word ptr _umss.um_priority,0
	mov	al,byte ptr btype
	mov	byte ptr _umss.um_data_type,al
	mov	word ptr _umss.um_callback_addr_seg,cs
	mov	word ptr _umss.um_callback_addr_off,offset _um_callback
	mov	bx,0
@@empty_buffs:
	mov	_buff_status[bx],BS_EMPTY
	inc	bx
	cmp	bx, NBUFFS
	jne	short @@empty_buffs
	mov	word ptr _fill_index,0
	mov	word ptr _play_index,0
	mov	word ptr _dma_index,0
	jmp	@@end_while
@@while:
	lea	ax,blength
	call	_check_buffers C, fp, ax
	mov	bx,_play_index
	mov	_buff_status[bx],BS_PLAYING
	mov	ax,bx
	mov	cl,BSIZE_BITS
	shl	ax,cl
	add	ax,offset _buffs
	mov	word ptr _umss.um_sound_data_seg,ds
	mov	word ptr _umss.um_sound_data_off,ax
	mov	cl,2
	shl	bx,cl
	mov	ax,word ptr _buff_len[bx+2]
	mov	dx,word ptr _buff_len[bx]
	mov	word ptr _umss.um_sound_len+2,ax
	mov	word ptr _umss.um_sound_len,dx
	mov	ax,_dma_index
	inc	ax
	mov	bx,NBUFFS
	cwd	
	idiv	bx
	mov	_dma_index,dx
	mov	word ptr _still_playing,1
	mov	ax, cs
	mov	es, ax
	mov	di, offset _umss
	mov	ax, TSR_START_DIGITAL
	call	_um_hook
	mov	word ptr _voice,ax
	cmp	ax,-1
	je	short @@done
	jmp	@@check_playing
@@keep_on_checking:
	lea	ax, blength
	call	_check_buffers C, fp, ax
@@check_playing:
	cmp	word ptr _still_playing,0
	jne	short @@keep_on_checking
@@end_while:
	cmp	_user_request_stop,0
	jne	short @@done
	mov	ax,word ptr [blength]
	or	ax,word ptr [blength+2]
	je	@@done
	jmp	@@while
@@done:
	jmp	@@close
@@ret:	ret
_play	endp

_main	proc	C near
	local	gf1mem:dword
	mov	ax, cs
	mov	ds, ax
	mov	ax, es
	mov	__psp, ax

	mov	bh, 0
	mov	di, 80h
	mov	bl, byte ptr es:[di]
	cmp	bl, 1
	jg	@@find_filename
	jmp	@@ret
@@find_filename:
	dec	bx
	mov	si, 82h
	mov	byte ptr es:[bx+si], 0
; copy file name into this segment
	push	ds
	push	ds
	mov	ax, es
	mov	ds, ax
	pop	es
	mov	di, offset _filename
	mov	cx, 80
	cld
	rep	movsb
	pop	ds

; find ultramid's entry point

	mov	al,078h
	mov	cx,6
@@next_vector:
	mov	ah,035h
	int	21h
; es is segment of gf1 driver.
; di is Offset into UltraMID's vector stamp.
	mov	di,0103H

	mov	si,offset chk_hook_str
	push	cx
	mov	cx,8
	cld
	repe	cmpsb
	jcxz	@@vector_valid
; Setup for next vector check.
	pop	cx
	inc	al
	loop	@@next_vector
	jmp	@@vector_not_found
@@vector_valid:
	pop	cx

	mov	ah,035h
	int	21h
	mov     [_hookoff], bx
	mov     [_hookseg], es

	mov	ax, TSR_APP_START
	call	dword ptr _um_hook

	xor	bx,bx
	mov	dx,8192
	mov	ax, TSR_ALLOCATE_MEMORY
	call	dword ptr _um_hook
	mov	word ptr [gf1mem+2],dx
	mov	word ptr [gf1mem],ax
	or	ax,dx
	je	short @@no_memory
	mov	ax, offset _filename
	call	_play C, ax, [gf1mem]
	mov	dx, word ptr [gf1mem]
	mov	bx, word ptr [gf1mem+2]
	mov	ax, TSR_FREE_MEMORY
	call	dword ptr _um_hook
	mov	ax, TSR_APP_END
	call	dword ptr _um_hook
	jmp	short @@ret
@@no_memory:
	mov	ax, offset msg_no_mem
	call	_myputs C, ax
	jmp	short @@ret
@@vector_not_found:
	mov	ax, offset msg_no_um
	call	_myputs C, ax
	jmp	short @@ret
@@ret:	
	ret	
_main	endp

msg_cant_open	db	"Can't open file ", 0
msg_cant_open1  db	' for playback',0
msg_RIFF	db	'RIFF',0
msg_WAVE	db	'WAVE',0
msg_fmt		db	'fmt ',0
msg_File	db	'File ',0
msg_isnt_wave	db	" isn't a .WAV format file",0
msg_cant_play	db	"This player can't play ",0
msg_bad_type	db	'.  Must be 8 or 16 bits',0
msg_data	db	'data',0
msg_no_data	db	".  Can't find data",0
msg_no_um	db	"Couldn't find UltraMID",13,10,0
msg_no_mem	db	'UltraSound card - out of memory',13,10,0
_filename db	80 dup (?)
_stbuff	db	2048 dup (?)
_buffs	db	BSIZE*NBUFFS dup (?)
_buff_len	label	word
	db	40 dup (?)
_buff_status	label	byte
	db	NBUFFS dup (?)
_fill_index	dw ?
_dma_index	dw ?
_play_index	dw ?
_still_playing	dw ?
_frequency	dw ?
_voice		dw ?
_TEXT	ends

	end start
