% newton.t uses newton iteration to solve a simultaneous nonlinear
% set of equations:
%
%   f1(x,y) = x^3 - x^2 * y + y^2 - 3.526
%   f2(x,y) = x^3 + y^3 - 14.911

type matrix2 : array( 2, 2 ) of real

var q : matrix2

var x : real := 1.0
var y : real := 2.0
var f1, f2 : real

function invert2( var m : matrix2 ) : boolean
    var n : matrix2
    var s : boolean
    var det : real

    det := m( 0, 0 ) * m( 1, 1 ) - m( 0, 1 ) * m( 1, 0 )
    if det = 0.0 then
        s := false
    else
        s := true
        n( 0, 0 ) :=  m( 1, 1 ) / det
        n( 0, 1 ) := -m( 0, 1 ) / det
        n( 1, 0 ) := -m( 1, 0 ) / det
        n( 1, 1 ) :=  m( 0, 0 ) / det
        m( 0, 0 ) := n( 0, 0 )
        m( 0, 1 ) := n( 0, 1 )
        m( 1, 0 ) := n( 1, 0 )
        m( 1, 1 ) := n( 1, 1 )
    end if
    return s
end invert2
        
program
    var i : int
    
    for i := 1 ... 5 do

        q( 0, 0 ) := 3 * x^2 - 2 * x * y
        q( 0, 1 ) := 2 * y - x^2
        q( 1, 0 ) := 3 * x^2
        q( 1, 1 ) := 3 * y^2

        if invert2( q ) then
            f1 := x^3 - x^2 * y + y^2 - 3.526
            f2 := x^3 + y^3 - 14.911

            x := x - q( 0, 0 ) * f1 - q( 0, 1 ) * f2
            y := y - q( 1, 0 ) * f1 - q( 1, 1 ) * f2

            watch( x )
            watch( y )
            put "x = ", x, " ", "y = ", y
        else
            put "singular"
            exit
        end if

    end for

end program
