% Bubble Sort Demonstration Program 

% The main routine reads from the terminal an array
% of ten real numbers and calls the procedure BUBBLE
% to sort them.


const TABLEN : int := 10                     % length of reals table

type TABLE : array( TABLEN ) of real         % Table of reals type 

var R : TABLE                                % The table itself
var i : int                                  % Table index 

%
% The sorting routine to sort in ascending order
%
procedure Bubble( var t : TABLE )

    var i, j : int
    var temp : real

    for i := 0 ... 8 do                      % the outer loop

        for j := i + 1 ... 9 do              % the inner loop 

            if t(i) > t(j) then

                temp := t(i)
                t(i) := t(j)
                t(j) := temp

            end if

        end for

    end for

end Bubble

program

    var n : int

    put "Bubble Sort Demonstration Program"

    for i := 0 ... 9 do
    
        put "input real number no. ", i + 1:2 
        put ": "...
        get R(i)

    end for                

    Bubble( R )                              % Sort the array 
 
    put ""                                   % Skip a line

    put "The sorted list from lowest to highest is:"

    for i := 0 ... 9 do 

        put R(i)
        n := ( i + 1 ) mod 5
        if n = 0 then 
            put ""
        end if
   
    end for

 end program

