/*
 * New editor name:  tde, the Thomson-Davis Editor.
 * Author:           Frank Davis
 * Date:             June 5, 1991
 *
 * This modification of Douglas Thomson's code is released into the
 * public domain, Frank Davis.  You may distribute it freely.
 *
 * This file contains all prototypes for every function in tde.  It should
 * be included in every source code module.
 */

/*************************  function prototypes in block.c *************/
int  mark_block( WINDOW * );
int  unmark_block( WINDOW * );
void restore_marked_block( WINDOW *, int );
int  prepare_block( WINDOW *, text_ptr, int, int );
void pad_dest_line( WINDOW *, file_infos *, text_ptr );
int  move_copy_delete_overlay_block( WINDOW * );
void load_box_buff( char *, text_ptr, int, int, char );
int  copy_buff_2file( WINDOW *, char *, text_ptr, int, int, int );
void block_fill( char *, int, int );
void number_block_buff( char *, int, long, int );
void restore_start_end( file_infos *, file_infos *, long, long, int );
void restore_cursors( file_infos *, file_infos * );
void delete_box_block( WINDOW *, text_ptr, int, int, int );
void check_block( void );
void find_begblock( file_infos * );
void find_endblock( file_infos * );
int  block_write( WINDOW * );
int  block_print( WINDOW * );
int  get_block_fill_char( WINDOW *, int * );
int  get_block_numbers( WINDOW *, long *, long *, int * );
int  block_expand_tabs( WINDOW * );
int  block_trim_trailing( WINDOW * );
int  block_convert_case( WINDOW * );
int  sort_box_block( WINDOW *window );
void insertion_sort_block( unsigned int, unsigned int, int );
text_ptr set_sort_begin( unsigned int );
text_ptr swap_lines( text_ptr, text_ptr );
void slide_down( text_ptr, text_ptr );
void load_pivot( text_ptr );
int  compare_pivot( text_ptr );
/************************************************************************/


/*************************  function prototypes in dirlist.c *************/
int  dir_help( WINDOW * );
int  validate_path( char *, char * );
int  list_and_pick( char *, char *, WINDOW * );
void setup_directory_window( DIRECTORY *, int );
void recalculate_dir( DIRECTORY *, FTYPE *, int );
void write_directory_list( FTYPE *, DIRECTORY );
int  select_file( FTYPE *, char *, DIRECTORY * );
void shell_sort( FTYPE *, int );
/************************************************************************/


/*************************  function prototypes in ed.c *****************/
int  tab_key( WINDOW * );
int  backtab( WINDOW * );
int  next_smart_tab( WINDOW * );
int  prev_smart_tab( WINDOW * );
int  insert_newline( WINDOW * );
int  insert_overwrite( WINDOW * );
int  join_line( WINDOW * );
int  dup_line( WINDOW * );
int  word_delete( WINDOW * );
int  back_space( WINDOW * );
int  line_kill( WINDOW * );
int  char_del_under( WINDOW * );
int  eol_kill( WINDOW * );
int  undo_line( WINDOW * );
int  undo( WINDOW * );
int  beg_next_line( WINDOW *window );
int  next_line( WINDOW *window );
int  home( WINDOW * );
int  goto_eol( WINDOW * );
int  goto_top( WINDOW * );
int  goto_bottom( WINDOW * );
int  set_tabstop( WINDOW * );
void show_line_col( WINDOW * );
void show_asterisk( WINDOW * );
int  toggle_overwrite( WINDOW * );
int  toggle_smart_tabs( WINDOW * );
int  toggle_indent( WINDOW * );
int  set_left_margin( WINDOW * );
int  set_right_margin( WINDOW * );
int  set_paragraph_margin( WINDOW * );
int  toggle_ww( WINDOW * );
int  toggle_crlf( WINDOW * );
int  toggle_trailing( WINDOW * );
int  toggle_z( WINDOW * );
int  toggle_eol( WINDOW * );
int  toggle_search_case( WINDOW * );
int  toggle_sync( WINDOW * );
int  toggle_ruler( WINDOW * );
void sync( WINDOW * );
void editor( void );
void display_dirty_windows( WINDOW * );
void show_dirty_window( WINDOW * );
int  play_back( WINDOW * );
int  pause( WINDOW * );
/************************************************************************/


/*************************  function prototypes in findrep.c ************/
int  get_replacement_flags( int );
int  ask_replace( WINDOW *, int * );
int  ask_wrap_replace( WINDOW *, int * );
void do_replace( WINDOW *, text_ptr, int );
int  find_string( WINDOW * );
void build_boyer_array( void );
text_ptr  forward_boyer_moore_search( WINDOW * );
text_ptr  search_forward( text_ptr, long );
text_ptr  backward_boyer_moore_search( WINDOW * );
text_ptr  search_backward( text_ptr, long );
void show_search_message( int, int );
void find_adjust( WINDOW *, text_ptr );
int  replace_string( WINDOW * );
int  replace_and_display( WINDOW *, text_ptr, int *, int *, int );
int  goto_top_file( WINDOW * );
int  goto_end_file( WINDOW * );
text_ptr  scan_forward( text_ptr, char, char, int * );
text_ptr  scan_backward( text_ptr, char, char, int * );
int  match_pair( WINDOW * );
int  goto_line( WINDOW * );
/************************************************************************/


/*************************  function prototypes in main.c  **************/
void main( int, char *[] );
void error( int, int, char * );
#if defined( __MSC__ )
void interrupt far harmless( void );
void interrupt far ctrl_break( void );
#else
static int harmless( void );
#endif
void terminate( void );
void hw_initialize( void );
void video_config( struct vcfg *cfg );
void hw_move( text_ptr, text_ptr, long );
int  hw_fattrib( char * );
int  change_mode( char *, int );
int  write_file( char *, char *, text_ptr, text_ptr, int );
int  hw_save( char *, text_ptr, text_ptr, int );
int  hw_append( char *, text_ptr, text_ptr, int );
int  hw_load( char *, text_ptr, text_ptr, text_ptr *, int );
int  get_help( WINDOW * );
void save_screen( void );
void restore_screen( void );
void show_credits( void );
int  getkey( void );
int  getfunc( int );
int  record_on_off( WINDOW * );
void record_keys( int );
void show_avail_strokes( void );
int  save_strokes( WINDOW * );
int  load_strokes( WINDOW * );
int  clear_macros( WINDOW * );
void connect_macros( void );
/************************************************************************/


/*************************  function prototypes in hwind.c **************/
void get_date( int *, int *, int *, int * );
void get_time( int *, int *, int *, int * );
void xygoto( int, int );
void save_screen_line( int, int, char * );
void restore_screen_line( int, int, char * );
void initialize( void );
void show_end_mem( void );
void show_end_text( WINDOW * );
void show_modes( void );
void show_file_count( int );
void show_window_count( int );
void show_avail_mem( void );
void show_smarttab_mode( void );
void show_indent_mode( void );
void show_search_case( void );
void show_sync_mode( void );
void show_wordwrap_mode( void );
void show_crlf_mode( void );
void show_trailing( void );
void show_control_z( void );
void show_insert_mode( void );
void my_scroll_down( WINDOW * );
void combine_strings( char *, char *, char *, char * );
void make_ruler( WINDOW * );
void show_ruler( WINDOW * );
void show_ruler_char( WINDOW * );
void show_ruler_pointer( WINDOW * );
void show_all_rulers( void );
/************************************************************************/


/*************************  function prototypes in utils.c **************/
int  myisalnum( int );
void check_virtual_col( WINDOW *, int, int );
void copy_line( text_ptr, int );
void un_copy_line( text_ptr, WINDOW *, int );
void load_undo_buffer( text_ptr );
int  load_file( char * );
void set_prompt( char *, int );
int  get_name( char *, int, char *, int );
int  get_sort_order( WINDOW * );
int  get_yn( void );
int  get_lr( void );
int  get_oa( void );
void show_eof( WINDOW * );
void display_current_window( WINDOW * );
int  redraw_screen( WINDOW * );
void redraw_current_window( WINDOW * );
void show_changed_line( WINDOW * );
void show_curl_line( WINDOW * );
void dup_window_info( WINDOW *, WINDOW * );
void addorsub_all_cursors( WINDOW *, long );
void adjust_windows_cursor( WINDOW *, int );
void adjust_start_end( file_infos *, long );
int  first_non_blank( char far * );
int  is_line_blank( char far * );
int  page_up( WINDOW * );
int  page_down( WINDOW * );
int  scroll_down( WINDOW * );
int  scroll_up( WINDOW * );
int  fixed_scroll_up( WINDOW * );
int  fixed_scroll_down( WINDOW * );
int  file_file( WINDOW * );
int  save_file( WINDOW * );
int  save_backup( WINDOW * );
int  write_to_disk( WINDOW *, char * );
int  save_as_file( WINDOW * );
void show_window_header( WINDOW * );
void show_window_number_letter( WINDOW * );
void show_window_fname( WINDOW * );
void show_size_name( WINDOW * );
void show_size( WINDOW * );
int  quit( WINDOW * );
int  move_up( WINDOW * );
int  move_down( WINDOW * );
int  prepare_move_down( WINDOW * );
int  move_left( WINDOW * );
int  move_right( WINDOW * );
int  scroll_left( WINDOW * );
int  scroll_right( WINDOW * );
int  word_left( WINDOW * );
int  word_right( WINDOW * );
int  center_window( WINDOW * );
int  horizontal_screen_right( WINDOW * );
int  horizontal_screen_left( WINDOW * );
int  set_marker( WINDOW * );
int  goto_marker( WINDOW * );
int  change_fattr( WINDOW * );
int  date_time_stamp( WINDOW * );
int  add_chars( char *, WINDOW * );
/************************************************************************/


/*************************  function prototypes in window.c *************/
int  initialize_window( void );
void choose_window( char *, WINDOW * );
int  next_window( WINDOW * );
int  prev_window( WINDOW * );
int  split_horizontal( WINDOW * );
int  split_vertical( WINDOW * );
void show_vertical_separator( WINDOW * );
int  size_window( WINDOW * );
int  zoom_window( WINDOW * );
int  next_hidden_window( WINDOW * );
void setup_window( WINDOW * );
void finish( WINDOW * );
int  create_window( WINDOW **, int, int, int, int, file_infos * );
int  edit_file( char * );
int  edit_another_file( WINDOW * );
int  edit_next_file( WINDOW * );
int  attempt_edit_display( char *, int );
void make_backup_fname( file_infos * );
/************************************************************************/


/**********************  function prototypes in wordwrap.c **************/
int  find_left_margin( text_ptr, int );
void word_wrap( WINDOW * );
int  format_paragraph( WINDOW *window );
void combine_wrap_spill( WINDOW *, int, int, int );
int find_word( text_ptr, int );
int  left_justify( WINDOW * );
int  right_justify( WINDOW * );
int  center_justify( WINDOW * );
/************************************************************************/


/*************************  function prototypes in tdeasm.c *************/
text_ptr cpf( text_ptr );
text_ptr cpb( text_ptr );
unsigned long  ptoul( void far * );
text_ptr nptos( text_ptr );
text_ptr addltop( long, text_ptr );
unsigned int find_CONTROL_Z( text_ptr );
unsigned int linelen( text_ptr );
text_ptr find_next( text_ptr );
text_ptr find_prev( text_ptr );
void update_line( WINDOW * );
void c_output( int, int, int, int );
void s_output( char far *, int, int, int );
void eol_clear( int, int, int );
void window_eol_clear( WINDOW *, int );
void upper_asm( text_ptr, unsigned );
void lower_asm( text_ptr, unsigned );
void strip_asm( text_ptr, unsigned );
int  get_fattr( char far *, int * );
int  set_fattr( char far *, int );
int  get_current_directory( char far *, int );
int  set_current_directory( char far * );
void hlight_line( int, int, int, int );
void cls( void );
void set_cursor_size( int );
int  findfirst( DTA far *, char far *, int );
int  findnext( DTA far * );
/*****************************************************/


/***********  function prototype for simul101.asm *************/
void far simulate_enh_kbd( int );
/*****************************************************/


/***********  function prototype for criterr.asm *************/
void far install_ceh( void far * );
/*****************************************************/


/***********  function prototype for criterr.c   *************/
int  far crit_err_handler( void );
void show_error_screen( int, int );
void save_area( void far * );
void restore_area( void far * );
/*****************************************************/
