/*
 * This module contains all the routines needed to save an existing macro
 * definition file in tde.exe
 *
 * Program Name:  tdecfg
 * Author:        Frank Davis
 * Date:          October 5, 1991
 */

#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "tdecfg.h"
#include "cfgmacro.h"

extern struct vcfg cfg;
extern FILE *tde_exe;                  /* FILE pointer to tde.exe */

static WINDOW *w_ptr;

MACRO macros;

/********    EXTREMELY IMPORTANT   ************/
/*
 * If you modify tde, it is your responsibility to find the offset of
 * the macro buffer in your new executable, tde.exe.
 *
 */



/*
 * Name:    tdehelp
 * Date:    October 1, 1991
 * Notes:   Set up most of the window global variables.
 */
void tdemacro( void )
{
int c;
int i;
char line[200];
char out_line[82];
char fname[82];
char *rc;
FILE *macro_file;                  /* FILE pointer to macro */
long offset;


   cls( );
   show_box( 0, 0, macro_screen, NORMAL );
   xygoto( 42, 14 );
   c = getkey( );
   while (c != '1' && c != '2')
      c = getkey( );
   if (c == '1') {
      puts( "" );
      puts( "" );
      puts( "" );
      puts( "Enter file name that contains the macro definitions :" );
      gets( fname );
      if ((c = access( fname, EXIST )) != 0) {
         puts( "\nFile not found.  Press any key to continue." );
         c = getkey( );
         cls( );
         return;
      } else if ((macro_file = fopen( fname, "rb" )) == NULL ) {
         puts( "\nCannot open macro file.  Press any key to contine." );
         c = getkey( );
         cls( );
         return;
      }

      fread( (void *)&macros, sizeof(MACRO), 1, macro_file );
      fseek( tde_exe, MACRO_OFFSET, SEEK_SET );
      fwrite( (void *)&macros, sizeof(MACRO), 1, tde_exe );
      fclose( macro_file );
      puts( "" );
      puts( "" );
      puts( "" );
      puts( "New macros successfully installed.  Press any key to continue." );
      c = getkey( );
   }
   cls( );
}
