; This program will dump data (usually stuff just in the header) of ANY file
; that I've created.

; Currently supports : FLK

; to do : M32, PIC, PAcKs? ...

include qlib.inc
include string.inc
include file.inc
include play.inc  ;for FLK format
include m32.inc   ;for M32 format

.data
  hand dw ?
  header db 3 dup (?)

.code
main proc,argc:byte,argv:dword
  callp print,"File STATS v1.01  by : Peter Quiring\n"
  .if argc!=2
    callp print,"Usage : STATS (file)        [Supports FLK,M32,PIC,EXE]\n"
    ret
  .else
    callp print,"\n"
  .endif
  mov eax,argv
  mov eax,[eax+1*4]  ;1st argument (file name)
  callp open,eax,0
  .if eax==ERROR
    callp print,"File not found\n"
    callp exit,0
  .endif
  mov hand,ax
  callp read,hand,offset header,3
  callp lseek,hand,0,SEEK_SET
  callp memcmp,offset header,"FLK",3
  .if !eax
    jmp FLK
  .endif
  callp memcmp,offset header,"M32",3
  .if !eax
    jmp M32
  .endif
  callp memcmp,offset header,"MZ",2
  .if !eax
    jmp EXE
  .endif
  callp close,hand
  callp printf,"File type unknown\n"
  ret
done::
  callp close,hand
  ret
main endp


.data
  flk_head play_flk <>

.code
FLK:
  callp read,hand,offset flk_head,sizeof flk_head
  callp printf," FLK format :\n"
  callp printf,"X : %w\n",flk_head.xres
  callp printf,"Y : %w\n",flk_head.yres
  callp printf,"bpp : %b\n",flk_head.bpp
  callp printf,"Frames : %w\n",flk_head.total
  callp printf,"Speed : %d\n",flk_head.spd
  callp printf,"Flgs : %b\n",flk_head.flgs
  jmp done

.data
  m32_head m32_headers <>

.code
M32:
  callp read,hand,offset m32_head,sizeof m32_head
  mov al,[m32_head.head+4]
  callp printf," M32 format : Ver%c\n",al
  callp printf,"Songname    : %s\n",offset m32_head.songname
  callp printf,"# patterns  : %b\n",m32_head.npat
  callp printf,"# channels  : %b\n",m32_head.nch
  callp printf,"bits/sample : %b\n",m32_head.res
  callp printf,"SampleRate  : %w\n",m32_head.freq
  callp printf,"Speed       : %b\n",m32_head.spd
  callp printf,"Notes/sec   : %b",m32_head.nfreq
  .if m32_head.nfreq==64
    callp printf,"  (M32 format)\n"
  .else  ;50!
    callp printf,"  (Amiga format)\n"
  .endif
  callp printf,"Samples     : "
  .if m32_head.saminc
    callp print,"YES\n"
  .else
    callp print,"No\n"
  .endif
  jmp done

.data
  exe_hdr db 28 dup (?)
.code
EXE:
  callp print,"EXE format:\n\n"
  callp read,hand,offset exe_hdr,sizeof exe_hdr
  callp printf,"Offset    Value           Description\n------------------------------\n"
  callp printf,"  0h(0)   %0Hwh(%0w)    Signature (MZ)\n",wptr exe_hdr[0],wptr exe_hdr[0]
  callp printf,"  2h(2)   %0Hwh(%0w)    Extra Bytes\n",wptr exe_hdr[2],wptr exe_hdr[2]
  callp printf,"  4h(4)   %0Hwh(%0w)    Pages(512 bytes)\n",wptr exe_hdr[4],wptr exe_hdr[4]
  callp printf,"  6h(6)   %0Hwh(%0w)    # Reloc Items\n",wptr exe_hdr[6],wptr exe_hdr[6]
  callp printf,"  8h(8)   %0Hwh(%0w)    EXE Header size(*16)\n",wptr exe_hdr[8],wptr exe_hdr[8]
  callp printf," 0ah(10)  %0Hwh(%0w)    Min alloc(*16)\n",wptr exe_hdr[0ah],wptr exe_hdr[0ah]
  callp printf," 0ch(12)  %0Hwh(%0w)    Max alloc(*16)\n",wptr exe_hdr[0ch],wptr exe_hdr[0ch]
  callp printf," 0eh(14)  %0Hwh(%0w)    Init SS\n",wptr exe_hdr[0eh],wptr exe_hdr[0eh]
  callp printf," 10h(16)  %0Hwh(%0w)    Init SP\n",wptr exe_hdr[10h],wptr exe_hdr[10h]
  callp printf," 12h(18)  %0Hwh(%0w)    Check Sum\n",wptr exe_hdr[12h],wptr exe_hdr[12h]
  callp printf," 14h(20)  %0Hwh(%0w)    Init IP\n",wptr exe_hdr[14h],wptr exe_hdr[14h]
  callp printf," 16h(22)  %0Hwh(%0w)    Init CS\n",wptr exe_hdr[16h],wptr exe_hdr[16h]
  callp printf," 18h(24)  %0Hwh(%0w)    Reloc Table Offset\n",wptr exe_hdr[18h],wptr exe_hdr[18h]
  callp printf," 1ah(26)  %0Hwh(%0w)    Overlay #\n",wptr exe_hdr[1ah],wptr exe_hdr[1ah]
  jmp done

end


