;plays flics (for vesa and VGA)
;plays *.FLK files (NOT FLC or FLI)
;see c:\32\grafix for a utility to convert BMP files into a FLK file.

; It plays 320x200x24 real fast and without any buffering!!
;will need to add some buffers someday  (256k?)
; it can be used for any other res. (it reads x/y from video.obj)

include qlib.inc

include file.inc
include string.inc
include key.inc
include video.inc
include play.inc

;3 types of storage avail in FLK  (somewhat like in FLI & FLC)
include play-rle.asm  ;RLE
include play-del.asm  ;delta
include play-cop.asm  ;copy (no compression)

.data?

bufs dd ?  ;bufsiz*2
buf dd ?
bufpos dd ?
bufend dd ? 
filepos dd ?
fh dw ?
frm dw ?    ;current frame
tfrm dw ?   ;total frames
bufsiz dd ?
pal db 768 dup (?)

header play_flk <>

.data
inited db 0
play_status db play_null  ;0=NOT LOADED  1=at 1st frame  2=elsewhere 3=at LAST frame
perror db 0
dopal db 0  ;pal needs updating flag

.code

play_init proc
  pushad
  mov eax,v_xbd
  mul v_yd
  mov bufsiz,eax

  shl eax,1 ;this is a lot of RAM but some frames can get larger than bufsiz!!
  mov bufs,eax   ;if you use relativly small animations rem the shift
  callp malloc,eax
  mov buf,eax
  add eax,bufs
  mov bufend,eax

  cmp buf,NULL
  jnz @f

badram:
  popad
  mov eax,ERROR
  ret
@@:
  mov inited,1
  popad
  xor eax,eax
  ret
play_init endp

play_uninit proc
  .if !inited
    mov eax,ERROR
    ret
  .endif
  callp free,buf
  mov inited,0
  xor eax,eax
  ret
play_uninit endp

play_open proc,fil:dword
  .if !inited
    mov eax,ERROR
  .endif
  mov perror,0
  pushad
  mov dopal,0
  callp open,fil,0
  cmp eax,ERROR
  jnz @f
  ret
@@:
  mov fh,ax
  callp read,fh,offset header,sizeof header    ;header
  .if header.flgs>1
    mov perror,1  ;unknown flags set
  .endif
  mov ax,header.total  ;total frames
  mov tfrm,ax
  mov frm,0
  mov play_status,play_1st
  .if !tfrm
    mov perror,1
  .endif
  xor eax,eax
  ret
play_open endp
  
play_close proc
  callp close,fh
  mov play_status,play_null
  ret
play_close endp

display proc private,decomp:byte
  .if perror
    ret
  .endif
@@:
  callp read,fh,buf,5
  mov ebx,buf
  mov al,[ebx]
  mov ecx,[ebx+1]  ;size
  .if al==4
    ;ecx=768 always
    .if ecx!=768
      mov perror,1
      ret
    .endif
    callp read,fh,offset pal,ecx
    mov dopal,1
    jmp @b
  .endif
  .if decomp
    .if al==1
      callp read,fh,v_buffer,ecx
    .elseif al==2
      callp read,fh,buf,ecx
      callp rle_decompress,buf,v_buffer
    .elseif al==3
      callp read,fh,buf,ecx
      callp delta,buf,v_buffer
    .else
      mov perror,1   ;to skip unknown sub-types rem this!
    .endif
  .else
    callp lseek,fh,ecx,SEEK_CUR
  .endif
  ret
display endp

play_seek proc,newfrm:word
  pushad
  .if (play_status==play_null)
bad:
    popad
    mov eax,ERROR
    ret
  .endif
  .if !newfrm      ;the proper range is from 1-x
    jmp bad
  .endif
  mov ax,newfrm
  .if ax>tfrm
    jmp bad
  .endif
  .if ax==tfrm
    mov play_status,play_done
  .else
    mov play_status,play_mid
  .endif
  dec newfrm
  .if zero?
    mov play_status,play_1st
  .endif
  callp lseek,fh,sizeof play_flk,SEEK_SET  ;skip over header
  mov frm,0
  xor ecx,ecx
  mov cx,newfrm
@@:
  jecxz @f
  push ecx
  callp display,0     ;don't decompress!
  pop ecx
  inc frm
  dec ecx
  jmp @b
@@:
  callp display,1  ;show next frame and inc frame #
  inc frm
  popad
  xor eax,eax
  ret
play_seek endp

play_next proc
  .if play_status==play_done
    mov eax,ERROR
    ret
  .endif
  pushad
  callp display,1
  inc frm
  mov ax,frm
  .if ax==tfrm
    mov play_status,play_done
  .else
    mov play_status,play_mid
  .endif
  popad
  .if perror
    mov eax,ERROR
  .else
    xor eax,eax
  .endif
  ret
play_next endp

play_pal proc   ;updates palette if needed
  .if dopal
    mov dopal,0
    callp setpal,offset pal
    mov eax,1
    ret
  .endif
  xor eax,eax
  ret
play_pal endp

play_play proc  ;plays flic till END is reached (no stopping it!)
  .if play_status==play_null
    mov eax,ERROR
    ret
  .endif
  pushad
@@:
  .if play_status==play_done
    popad
    xor eax,eax
    ret
  .endif
  call play_next
;you could add stuff here to update current screen (eg: add jets/score/etc.)
;  but you should force all the BMPs to have the same pal (3DS can do that)
  call play_pal
  call v_copy
  jmp @b
play_play endp

end
