;  Malloc - just like in C
; All I do is keep simple 12 byte headers in front of each block of RAM.
; First 2 byte = 'PQ'.  Second = flags. (a junk byte here ). Then next dword
; is a pointer to the previous block header and the next dword is the size
; of this block.  Flags are used to tell if a block is free and/or last one.

; All alloc RAM will be dword aligned!

; This is what each header looks like
heads struct  ;12bytes
  magic dw ? ; 'PQ' ;signature
  flag db ?  ;bit0=free(1)  bit1=last(2)   (1==true)
  _a1 db ?   ;junk byte for alignment (not used!)
  prev dd ?  ;ptr=>previous block
  siz dd ?   ;size of this block
heads ends

.data
_baseram dd ? ;RAM base (relative)
_dma1used db 0
_dma1phy dd ? ;physical
_dma1rel dd ? ;relative
_dma2used db 0
_dma2phy dd ? ;physical
_dma2rel dd ? ;relative

.code

extern print_regs:near

dd 0     ;Must be here or debugger will not run properly
         ;For some reason the debugger does not like code @ 0
         ;(because some other code wraps around @ 0ffffffffh)
         ; This is now needed for NULL ptrs : V1.1
malloc_init proc private
  mov ax,0ee41h
  int 31h
  .if carry?
    mov _dma1used,1
  .else
    mov _dma1phy,ebx
    mov _dma1rel,edx
  .endif
  mov ax,0ee41h
  int 31h
  .if carry?
    mov _dma2used,1    ;FIX V1.1  (was dma1used?) that's what you get for block copying code
  .else
    mov _dma2phy,ebx
    mov _dma2rel,edx
  .endif
  mov ax,0ee42h
  mov edx,-1     ;alloc as much as possible
  int 31h  ;eax=true size  edx=ptr
  push eax
  mov ax,0ee40h
  int 31h
  pop eax
  mov ebx,eax
  sub ebx,HEAP_BASE
  .if ebx<HEAP_MIN
    .if eax<HEAP_MIN
      jmp bad
    .endif
  .else
    mov eax,ebx
  .endif
  .if eax>HEAP_MAX
    mov eax,HEAP_MAX
  .endif
  mov edx,eax
  mov ax,0ee42h
  int 31h
  .if eax<HEAP_MIN
    jmp bad
  .endif
    
  mov _baseram,edx

  mov word ptr[edx].heads.magic,5150h  ;'PQ'=50,51
  mov byte ptr[edx].heads.flag,3h   ;last&free
  mov dword ptr[edx].heads.prev,0   ;no prev!
  sub eax,sizeof heads
  and eax,0ffffffffh-3  ;align 4
  mov dword ptr[edx].heads.siz,eax
  ret
bad:
  callp print,"Out of memory...\n"
  callp exit,3
malloc_init endp

malloc proc,sz:dword
  pushad
  cmp sz,0
  jnz @f
bad:
  popad
  mov serror,ERROR_RAM
  mov eax,ERROR
  ret
@@:
  ;make sure alloc block is dword aligned
  test sz,3
  .if !zero?
    and sz,0ffffffffh-3
    add sz,4
  .endif
  ;search thru chain for best fit
  mov eax,_baseram  ;ram start
  mov ebx,0     ;best fit location
  mov ecx,-1    ;best fit is ecx too much over sz
start:
  mov dl,[eax].heads.flag
  test dl,1  ;free?
  jnz ok3
next:
  mov dl,[eax].heads.flag
  test dl,2  ;last?
  jnz endsrc
  add eax,[eax].heads.siz
  add eax,sizeof heads
  jmp start
ok3:
  ;found one that's free
  mov edx,[eax].heads.siz
  sub edx,sz
  jb next ;too small
  ;found one big enough
  cmp edx,ecx
  jae next ;already got another that's better
  ;this one's better
  mov ecx,edx
  mov ebx,eax
  jmp next
endsrc:
  ;end of search
  cmp ebx,0
  jz bad
;split ebx into 2 blocks:1st = used 2nd = free
  mov eax,ebx
  xor [ebx].heads.flag,1  ;set as used!
  cmp ecx,256  ;don't make a really small block
  ja ok4
  add ecx,sz
  mov [ebx].heads.siz,ecx  ;set size (all of it)
  add eax,sizeof heads
  mov [esp+7*4],eax
  popad
  ret
ok4:
  mov edx,sz
  mov al,[ebx].heads.flag
  and al,2        ;mask last
  xor [ebx].heads.flag,al  ;remove last if it's there
  mov [ebx].heads.siz,edx ;set size
  add edx,ebx
  add edx,sizeof heads
  mov [edx].heads.magic,5150h  ;free only
  mov [edx].heads.flag,1
  or [edx].heads.flag,al  ;set if last
  mov [edx].heads.prev,ebx  ;set prev
  sub ecx,sizeof heads
  mov [edx].heads.siz,ecx  ;set size
  mov eax,ebx
  add eax,sizeof heads
  mov [esp+7*4],eax
  popad
  ret
malloc endp

calloc proc,siz1:dword,siz2:dword   ;it's like size,n_size type thing
  ;this clears the alloc RAM to 0
  local siz:dword
  pushad
  mov eax,siz1
  mov ebx,siz2
  mul ebx
  mov siz,eax
  callp malloc,eax
  .if eax==ERROR
    popad
    mov eax,ERROR
  .endif
  mov [esp+7*4],eax  ;save for ret
  mov edi,eax
  mov eax,0
  mov ecx,siz
  mov ebx,ecx
  shr ecx,2
  rep stosd
  mov ecx,ebx
  and ecx,3
  .if !zero?
    rep stosb
  .endif
  popad
  ret
calloc endp

free proc,b:dword
  pushad
  mov eax,b
  cmp eax,0
  jnz ok6
bad:
  popad
  mov serror,ERROR_RAM   ;just ignore
  mov eax,ERROR
  ret
ok6:
  sub eax,sizeof heads
  cmp eax,_baseram
  jz ok7 ;no above!
  mov ebx,[eax].heads.prev
  test [ebx].heads.flag,1
  jz ok7
  ;above is free

  mov dl,[eax].heads.flag  ;must copy flags to above block
  mov ecx,[eax].heads.siz
  mov eax,ebx
  add ecx,sizeof heads
  add [eax].heads.siz,ecx
  mov [eax].heads.flag,dl
ok7: ;done joining with above block
  mov ebx,[eax].heads.siz
  add ebx,eax
  add ebx,sizeof heads
  test byte ptr[ebx].heads.flag,1
  jz ok8
  mov ecx,[ebx].heads.siz
  add ecx,sizeof heads
  add [eax].heads.siz,ecx
  mov dl,[ebx].heads.flag
  mov [eax].heads.flag,dl
ok8: ;done joining below
  or [eax].heads.flag,1  ;mark as free
  popad
  xor eax,eax
  ret
free endp

qfree proc ;query free ram  ;out:eax=largest  ebx=total
  pushad
  mov ecx,_baseram
  xor eax,eax  ;largest
  xor ebx,ebx  ;total
  xor edx,edx  ;size of last block
  sub ecx,sizeof heads
start:
  add ecx,sizeof heads
  add ecx,edx
  mov edx,[ecx].heads.siz
  test [ecx].heads.flag,1
  jz @f
  add ebx,edx
@@:
  cmp edx,eax
  jbe nope
  mov eax,edx
nope:
  test [ecx].heads.flag,2
  jz start
  mov [esp+7*4],eax
  mov [esp+4*4],ebx
  popad
  ret
qfree endp

alloc_dma16 proc
  cmp _dma1used,0
  jnz @f
  mov ebx,_dma1phy
  mov edx,_dma1rel
  xor eax,eax
  ret
@@:
  cmp _dma2used,0
  jnz @f
  mov ebx,_dma2phy
  mov edx,_dma2rel
  xor eax,eax
  ret
@@:
  mov eax,ERROR  ;FIXED : Ver1.1   (was NULL?)
  ret
alloc_dma16 endp
