// Warning : this file contains code!

#ifndef __QLIB_H__
#define __QLIB_H__

/* Below is different than from 16bit C typedefs */
typedef unsigned char byte;
typedef unsigned short int word;
typedef unsigned long int dword;

/* signed versions */
typedef signed char sbyte;
typedef signed short int sword;
typedef signed long int sdword;

extern dword alloc_dma16(void);   /*=ERROR if not avail  */
extern void getint(byte v);       /*ax:edx              */
extern sbyte setint(byte v,word s,dword off);
extern sbyte setrmint(byte v,word s,word off);
extern void interrupt (*getvect(byte i));
extern void setvect(byte i,void interrupt (*v));
extern void getrmint(byte v);
extern void alloc_rmcallback(dword off);   /*cx:dx = real mode loc.  */
extern void alloc_rmintcallback(dword off);  /*cx:dx = real mode loc.  */
extern void* malloc(dword sz);   /*ERROR=error */
extern dword qfree(void);        /*query free ram  ;out:eax=largest  ebx=total*/
extern sbyte free(void * b);
extern void* getenv(byte* nam);
extern void exit(byte el);
extern void abort(void);
extern byte lock_ram(dword off,dword siz);
extern byte unlock_ram(dword off,dword siz);

extern void outp(word p,byte d);
extern byte inp(word p);
extern void outpw(word p,word d);
extern word inpw(word p);

extern void int86(byte i,union REGS *rin,union REGS *rout);
extern void int86x(byte i,union REGS *rin,union REGS *rout,struct SREGS *sreg);
extern void int386(byte i,union REGS *rin,union REGS *rout);

extern byte _os;
extern word selcode;
extern word seldata;
extern word selzero;
extern dword _environ;
extern dword _psp;
extern dword atexit;
extern dword _base;
extern byte _argstr;  /* ;129 dup (?) */
extern byte ** _argv;
extern byte _argc;
extern byte _pmmode;
extern dword _filename;
extern dword _size;
extern byte _fpu;
//extern word _ds;
//extern word _es;

extern word serror;
extern word merror;

#define NULL 0
void *NULL_PTR=0;
extern void NULLPROC(void);
#define ERROR 0xffffffff

// Watcom C calls this for some reason not and then !
// I could be like the stack overflow check thing that I was able to disable
// Hope it was not important

#ifdef __WATCOMC__
  #pragma aux default "_*";      //add underscore to all variables
#endif

struct BYTEREGS  {
  byte  al, ah;  word _1;
  byte  bl, bh;  word _2;
  byte  cl, ch;  word _3;
  byte  dl, dh;  word _4;
};

struct WORDREGS  {
  word  ax,_1;
  word  bx,_2;
  word  cx,_3;
  word  dx,_4;
  word  si,_5;
  word  di,_6;
  word  cflag,_7;
};

struct DWORDREGS  {
  dword  eax, ebx, ecx, edx;
  dword  esi, edi, cflag;
};

union REGS {
  struct  DWORDREGS  x;
  struct  WORDREGS  w;
  struct  BYTEREGS  h;
};
#define _REGS REGS

// NOTE: int86x() & int386x() ignores ss,cs
struct SREGS {
  word  es;
  word  cs;
  word  ss;
  word  ds;
  word  fs;
  word  gd;
};
#define _SREGS SREGS

// Here is stuff for compatibility
#define memmove memcpy       //my memcpy is capable of overlaps
#define atol str2num
#define atoi str2num

#endif

