m32_trks struct ;tracking structure
  on db ?   ;channel on?
  off dd ?  ;offset in RAM from DS
  boff dd ? ;begin of sample (used only in 16bit sample mixing)
  freq dw ?
  vol dw ?,0  ;main volume (from instr.)
  voll dw ?,0 ;volume left channel
  volr dw ?,0 ;volume right channel
  send dd ?   ;sample end
  repb dd ?   ;begin 0=none
  reps dd ?   ;stop
  of db ?   ;overflow
  ;effect data
  cmd db ?
  cmdb1 db ?
  cmdb2 db ?
  ;others
  vibidx db ?  ;current vibrato index
m32_trks ends

m32_instrs struct ;36 * 255 = 9180
  iname db 18 dup (?)
  vol  dw ? ;volume
  off  dd ? ;offset in RAM (length in file)
  send dd ? ;sample end
  repb dd ? ;begin
  reps dd ? ;stop   (length in file)
m32_instrs ends

m32_pats struct ;pattern structure  (6 bytes)
  note db ? ;instrument to use  0=none
  freq dw ? ;frequency
  eff db ?  ;effect command
  effd1 db ? ;effect data #1
  effd2 db ? ;effect data #2
m32_pats ends

m32_headers struct
  head db 6 dup (?)   ;'M32V1',26
  songname db 20 dup (?)
  npat db ?        ; # of patterns
  nch db ?         ; # of channels
  res db ?         ; sound resolution (8,16)
  freq dw ?        ; sample rate  (must be 11050/22050 or 44100)
  spd db ?         ; speed  4=min.  (4 means every 4 updates is a new note)
  nfreq db ?       ; note freq (64=m32's  50=mod's)
  saminc db ?      ; samples in MOD file (1=yes,0=no)  (could be in sample bank *.bnk)
  reserved db ?,?,? ;reserved!
  songdat db 256 dup (?)  ;0=end of music
m32_headers ends

m32_init proto,snds:byte,maxps:dword,maxss:dword
m32_play proto
m32_load proto,strg:dword
m32_loadsmp proto
m32_addnote proto,chnl:dword,sfx:dword,vol:word,freq:word  ;vol:0-100h
m32_setvol proto,chnl:dword,lvol:byte,rvol:byte
m32_stop proto
m32_pause proto
m32_cont proto
m32_oprint proto

;externdef is used as a public if the data is declared in current
; obj file or as an extern if not  (real good)  Now I use only 1 inc file!

externdef m32_header:m32_headers
externdef m32_instrdat:byte  ;255*sizeof m32_instrs
externdef m32_marker:word    ;last marker found in M32
externdef m32_card:byte   ;cards type  SB16=1 Gus=2
externdef m32_mode:byte   ;0=stoped !0=playing
externdef m32_patloc:dword
externdef m32_samloc:dword
externdef m32_patbsize:dword
externdef m32_pat_skip:dword
externdef m32_pat_width:byte
externdef m32_2nd:byte ;indicates if IRQ was ever called
externdef m32err:byte
  ;Error codes:
  ; 0 - none
  ; 1 - SB card not found
  ; 2 - Enviro string not found or set incorrectly
  ; 3 - Load fail
  ; 4 - not enough RAM
 
