ce equ 4    ;close enough value  (for 24bit only)
; value must be >=2
; Used in 16/24bit delta compression
; If a pixel only changes by ce value then it is assumed to have not changed
; BUG: what if something changes very slowly from white to black?
; FIX: updated bs2 to bs1 if ce used
; a value of 2 will never be noticed but can do pretty good compression
; the higher the better:but worse quality (haven't yet tried to see what happens)
; but without it the delta compression usually is useless on 24bit pix
; A value of 10 is VERY noticable

; this compressor has been completely overhauled  Ver1.1

;does NOT preserve regs!
delta proc,bs1:dword,bs2:dword,bd:dword
  local fixup:dword   ;used in neg compression (to fix up len of copy)
  local off:dword     ;offset to 1st line (byte)
  local first:dword   ;offset of first line that has changed
  local last:dword    ;" last byte
  local save:byte   ;thing
  local ff:byte     ;flag

  cld
  mov edi,bd  ;dest
  mov al,3
  stosb ;store 3 (delta type)

  ;make delta mask on bs1
  mov esi,bs1 ;source1
  mov edi,bs2 ;source2  (make a delta from 1 to 2)
  mov ecx,bufsiz
;ecx=len to delta mask
  xor ebx,ebx  ;current y
  xor edx,edx  ;current x
  mov ff,0
@@:
  mov ah,[esi]  ;used by cee
  mov save,ah
  mov al,[edi]
  cmpsb
  mov bptr[esi-1],0   ;clear until provein set
  jz ok1
  .if cee   ;close enough enabled?
    .if ah>al
      xchg al,ah
    .endif
    sub al,ah
    .if al<ce
      jmp not_mismatch
    .endif
  .endif
setit:
  inc bptr[esi-1]  ;set it
  .if (!ff)
    mov first,ebx
    inc ff  ;flag
  .endif
  mov last,ebx
  jmp ok1
not_mismatch:
  mov al,save
  mov [edi-1],al
ok1:
  inc edx
  .if edx==xresb
    xor edx,edx
    inc ebx
  .endif
  dec ecx
  jnz @b
  ;mask created!
  ;now lets creat the delta output

  .if !ff
    ;no difference! (this is good for repeated frames!)
    mov edi,bd
    inc edi
    mov eax,4 ;only the 2 words
    stosd ;size
    mov eax,yres
    stosw        ;start=yres = no change!
    mov ax,0
    stosw        ;length=0
    mov eax,9    ;no data!
    ret
  .endif

;now lets optimize stuff
;OP#1  ;if there is a hole in the data, it's better if we fill it in
  mov esi,bs1
  inc esi
  mov ecx,bufsiz
  sub ecx,3
@@:
  .if (bptr[esi-1]) && (bptr[esi+1])
    mov bptr[esi],1
  .endif
  .if (bptr[esi-1]) && (bptr[esi+2])
    mov bptr[esi],1
    mov bptr[esi+1],1
  .endif
  inc esi
  dec ecx
  jnz @b
;OP#2 ;using cee again lets try and find pixels side by side that are close
      ;enough to each other that we can change one to the other
; l8r!

  mov edi,bd
  add edi,5   ;size (fixed l8r)
  mov eax,first
  stosw         ;first line (offset)
  mov ebx,last
  sub bx,ax
  inc bx
  mov [edi],bx  ;# lines in delta output
  add edi,2
  mul xresb
  mov ecx,eax   ;first
  mov off,ecx
  mov eax,last
  inc eax
  mul xresb
  sub eax,ecx
  mov ecx,eax   
  mov edx,edi

;now creat delta output using delta mask
  mov edi,bs1
  mov esi,bs2     ;I switched here for ease
  add edi,off
  add esi,off
  xor al,al ;skip #

  ;ecx=len to delta mask
  ;esi=buffer 2 (data)
  ;edi=buffer 1 (masked)
  ;edx=out buffer

@@top:
  jecxz done
  .if ecx==1  ;1byte left
    mov [edx],al
    inc edx
    mov bptr[edx],1   ;or 128+1 would work too
    inc edx
    lodsb
    mov [edx],al
    inc edx
    xor al,al
    jmp done
  .endif
  cmp byte ptr[edi],0
  jnz start
  inc edi
  inc esi
  dec ecx
  inc al
  cmp al,255
  jnz @@top
  mov [edx],al
  inc edx
  inc al ;al=0
  jmp @@top

start: ;start of a mask area
  ;place skip #
  mov [edx],al  ;al can never = 255 here! (because that means there is no sub-packet)
  inc edx
  mov al,[esi]
  cmp al,[esi+1]
  jz usepos

useneg: ;data stream
  xchg edi,edx
  xor bl,bl  ;127=max
  mov fixup,edi
  inc edi ;fixup l8r
@@:
  movsb
  inc edx ;the mask
  inc bl
  dec ecx
  jz usenegdone
  cmp bl,127
  jz usenegdone
  cmp bptr[edx],0
  jz usenegdone
;  mov al,[esi]
;  cmp al,[esi+1]
;  .if (zero?) && (ecx>2)  ;should we switch to pos?
;    .if bptr[edx]  ;rem: i switched them
;      .if bptr[edx+1]
;        ;if they are the same lets switch to replicator mode 
;        jmp usenegdone ;(50/50 chance it will be better)
;      .endif
;    .endif
;  .endif
  jmp @b
usenegdone:
  or bl,128
  mov eax,fixup
  mov [eax],bl
  xor al,al
  xchg edx,edi
  jmp @@top

;placed here cause jumps are not close enough
done:
  ;must save last skip#
  .if al
    mov [edx],al
    inc edx
  .endif
  ;edx=EOdata (next avail loc)
  mov eax,edx
  sub eax,bd
  mov ebx,bd
  inc ebx
  mov [ebx],eax
  sub dword ptr[ebx],5 ;not including header
;ret: eax=total size to write out
  ret

usepos: ;replicate
  xchg edi,edx
  mov al,[esi]
  xor bl,bl
@@:
  cmp al,[esi]
  jnz useposdone
  inc bl
  inc esi
  inc edx
  dec ecx
  jz useposdone
  cmp byte ptr[edx],0
  jz useposdone
  cmp bl,127
  jnz @b
useposdone:
  xchg al,bl
  stosb  ;store packet type/size  (1/7)
  mov al,bl
  stosb  ;store data
  xchg edx,edi
  xor al,al
  jmp @@top

delta endp

