; TODO : add packet type #4 (palette!) for 8bits only!

; NOTE : This has been tested on 24bit BMPs only!
;       and that's all it really supports so far

; NEW ver 1.01 : Now can load OS/2 & win3.0 BMPs  (8 or 24bit)
;                And FLK supports Palettes

include qlib.inc

include file.inc
include string.inc
include video.inc
include key.inc
include play.inc

delta2first equ 0 ;Do delta to 1st frame from last frame (good for looping)
                  ;this is when an extra delta frame is created that will
                  ;allow the FLIC playback to goto frame#1 fast
                  ;also frame2 is also used to quickly seek to frame#2
.data

largest dd 0
file db 'XXXX0000.bmp',0
first_file db 13 dup (0)

filei dd 0  ;file names
fileo dd 0

crlf db 13,10,0
cee db 0  ;ce enabled  (see delta.asm)
byp dd 0
bufsiz dd 0
oldpal db 768 dup (0)
rlesiz dd 0

header db 'FLK',26
  hxres dw 0
  hyres dw 0
  bpp db 0
  total dw 0    ;total (fix l8r)
  frame2 dd 0   ;frame 2 (fix l8r)
  spd dd 0      ;speed
  flgs db 0     ; bit 0:delta to 2nd frame included
                ; bit 7-1 : reserved (ignored for now) (may be used to indicate
                ;  future compression scemes)
  db 4 dup (0)  ;reserved

  bi1 dword 0  ;input 1 frame n
  bi2 dword 0 ;input 2 frame n
  bo dword 0  ;output (256K) (compressed)

buf1 dword 0
buf2 dword 0 ;current buffers

xres dd 0
xresb dd 0   ;x*bypp
yres dd 0
pal_head db 4
 dd 768
num dw 0  ;current number
frm dw 0    ;current frame
maxfrm word 0   ;MAX frame # allowed
fo word 0  ;file out handle

include loadbmp.asm

.code

include num2str.asm
;Palette            ;4
include delta.asm   ;3
include rle.asm     ;2
include copy.asm    ;1
include invert.asm

;code
main proc
  ;buffers

  invoke print,"BMP2FLK v1.01 by Peter Quiring\n"

  jmp @f
badram:
  mov eax,"Error:Out of RAM\n"
error1:
  callp print,eax
  callp exit,0
badarg:
  mov eax,"USAGE: BMP2FLK infile(4 letters only) outfile [max_frames]\n"
  jmp error1
badfile:
  mov eax,"Error:file I/O\n"
  jmp error1
@@:

  .if _argc<3
    jmp badarg
  .endif

  mov ebx,_argv
  mov eax,[ebx+1*4]
  mov filei,eax
  mov eax,[ebx+2*4]
  mov fileo,eax
  mov maxfrm,9999
  .if _argc==4
    mov eax,[ebx+3*4]
    callp str2num,eax
    .if ax<10000
      mov maxfrm,ax
    .endif
  .endif

  invoke strlen,filei
  cmp eax,4
  jnz badarg

  mov esi,filei
  mov edi,offset file
  mov ecx,4
  rep movsb

;all setup
  invoke creat,fileo,0
  cmp eax,ERROR
  jz badfile
  mov fo,ax

  callp print,"ESC - quit after current frame\n"

  mov num,0
  mov frm,0

  callp get_bmp,1  ;1st call will only set bufsiz according to 1st file
  callp malloc,bufsiz
  .if eax==ERROR
    jmp badram
  .endif
  mov bi1,eax
  callp malloc,bufsiz
  .if eax==ERROR
    jmp badram
  .endif
  mov bi2,eax
  mov eax,bufsiz  
  shl eax,1  ;*2  ;some frames may get larger (rare)
  invoke malloc,eax
  .if eax==ERROR
    jmp badram
  .endif
  mov bo,eax

  mov eax,bi1
  mov buf1,eax
  mov eax,bi2
  mov buf2,eax

  movzx eax,bmp_x
  mov hxres,ax
  mov xres,eax
  movzx ebx,bmp_y
  mov hyres,bx
  mov yres,ebx
  .if bmp_bpp==8
    mov bpp,8
    mov byp,1
    mov xresb,eax
    mul ebx
    mov bufsiz,eax
  .else
    mov bpp,24
    mov byp,3
    imul eax,3
    mov xresb,eax
    mul ebx
    mov bufsiz,eax
    inc cee    ;enable extra 24bit compression
  .endif

  callp get_bmp,0

  invoke write,fo,offset header,24    ;fixup some l8r
  callp strcpy,offset first_file,offset file  ;used in delta last 2 1st

  callp comp_bmp,0  ;delta not allowed
@@:
  callp get_bmp,0
  callp comp_bmp,1  ;allow delta now
  jmp @b
main endp

get_bmp proc,first:byte
  call getch
  .if al==27
    call end_it
  .endif

  ;make file=frm #
@@:
  mov ax,maxfrm
  .if num>ax
    call end_it
  .endif
  callp _num2str,(offset file+4),num
  callp load_bmp,offset file,buf2
  .if eax==ERROR
    callp print,"."
    inc num
    jmp @b
  .endif
  .if first
    ret
  .endif
  mov bx,bmp_x
  .if bx!=hxres
    jmp badBMP
  .endif
  mov bx,bmp_y
  .if bx!=hyres
    jmp badBMP
  .endif
  mov bx,bmp_bpp
  .if bl!=bpp
    jmp badBMP
  .endif
  inc frm
  inc num
  ret
badBMP:
  callp printf,"BMP x,y or bpp has changed!\n"
  call end_it
get_bmp endp

comp_bmp proc,dodelta:byte
  ;delta=1 if delta is allowed  (not true on 1st frame only)
  call do_pal
  callp rle_compress,buf2,bo
  mov rlesiz,eax
  .if dodelta
    callp delta,buf1,buf2,bo
  .else
    mov eax,-1  ;ensure delta is not used
  .endif
  mov bl,1  ;best comp == COPY
  mov ecx,rlesiz
  .if ecx<bufsiz
    mov bl,2
  .endif
  .if (eax<bufsiz) && (bl==1)
    mov bl,3
  .elseif (eax<rlesiz) && (bl==2)
    mov bl,3
  .endif
  .if bl==1
    callp copy,buf2,bo
    mov bl,1
    jmp do_it
  .elseif bl==2
    .if dodelta
      callp load_bmp,offset file,buf2  ;reload because delta can corrupt it
      callp rle_compress,buf2,bo
    .else
      mov eax,rlesiz
    .endif
    mov bl,2
    jmp do_it
  .endif ;do delta
do_it:
  mov ecx,eax  ;preserve eax until...
  .if eax>largest
    mov largest,eax
  .endif
  callp print,"\n"
  callp print,offset file
  .if bl==1
    callp print,"(COPY)"
  .elseif bl==2
    callp print,"(RLE)"
  .else
    callp print,"(DELTA)"
  .endif
  callp write,fo,bo,ecx           ;...here
  callp printf," = %d\n",ecx

;change buffers
  mov eax,buf1
  mov ebx,buf2
  mov buf1,ebx
  mov buf2,eax
  ret
comp_bmp endp

end_it proc  ;finish up stuff & quit

  .if !frm
    callp close,fo
    callp unlink,fileo
    callp exit,0
  .endif

  callp do_delta2first,delta2first

  mov ax,frm
  mov total,ax
  add frame2,24  ;to include header!
  invoke lseek,fo,0,0
  invoke write,fo,offset header,24
  
  invoke close,fo

  callp printf,"\n Largest = %d\n",largest
  mov eax,bufsiz
  .if eax>largest
    callp print,"Largest < bufsiz\n"
  .else
    callp print,"Largest > bufsiz !!!\n"
  .endif

  callp exit,0
end_it endp

paldone db 0  ;flag

do_pal proc
  .if bpp==8
    .if !paldone
      inc paldone
    .else
      callp memcmp,offset oldpal,offset bmppal,768
      .if !eax   ;palette has NOT changed
        ret
      .endif
    .endif
  .else
    ret  ;no palette
  .endif
  invoke write,fo,offset pal_head,5
  invoke write,fo,offset bmppal,768
  invoke memcpy,offset oldpal,offset bmppal,768
  callp printf," (PAL) = (768+5)\n"
  ret
do_pal endp

do_delta2first proc,yes:byte
  ;this will creat the delta to 1st frame if wanted (for loop playback)
  ; flag=1 if yes =0 if not
  .if !yes
    mov flgs,0
  .else
    mov flgs,1
    ; do it later
  .endif
  ret
do_delta2first endp

end
