/*
	STDLIB32 for PMC
	(c) Ng Yew Choong (arjuna/sad little people) 1995
	stdlib32.h - stdlib32 header file
*/

#ifndef __PMC_STDLIB__
#define __PMC_STDLIB__

#ifdef __cplusplus
extern	"C"	{
#endif

#define _IS_SP	1			/* is space */
#define _IS_DIG	2			/* is digit indicator */
#define _IS_UPP	4			/* is upper case */
#define _IS_LOW	8			/* is lower case */
#define _IS_HEX	16			/* [A-F or [a-f] */
#define _IS_CTL	32			/* Control */
#define _IS_PUN	64			/* punctuation */

extern	char _ctype[];	 

#define isalnum(c)	(_ctype[(c) + 1] & (_IS_DIG | _IS_UPP | _IS_LOW))
#define isalpha(c)	(_ctype[(c) + 1] & (_IS_UPP | _IS_LOW))
#define isascii(c)	((unsigned)(c) < 128)
#define iscntrl(c)	(_ctype[(c) + 1] & _IS_CTL)
#define isdigit(c)	(_ctype[(c) + 1] & _IS_DIG)
#define isgraph(c)	((c) >= 0x21 && (c) <= 0x7e)
#define islower(c)	(_ctype[(c) + 1] & _IS_LOW)
#define isprint(c)	((c) >= 0x20 && (c) <= 0x7e)
#define ispunct(c)	(_ctype[(c) + 1] & _IS_PUN)
#define isspace(c)	(_ctype[(c) + 1] & _IS_SP)
#define isupper(c)	(_ctype[(c) + 1] & _IS_UPP)
#define isxdigit(c)	(_ctype[(c) + 1] & (_IS_DIG | _IS_HEX))

#define _toupper(c)	((c) + 'A' - 'a')
#define _tolower(c)	((c) + 'a' - 'A')
#define toascii(c)	((c) & 0x7f)


extern int argc;
extern char *argv[];
int get_args(void);

int tty_putchr(int c);
int tty_putstr(PTR str);
int tty_putstr_raw(PTR str);

int _itoa(int num, STR str, int radix, int sign, int prec);
int _atoi(STR str, int radix);

int sprintf(STR buff, STR fmt, ...);

#ifdef __cplusplus
};
#endif

#endif
