PROGRAM Test_HSC;

USES CRT;

CONST EqColors : ARRAY [0..15] OF BYTE = (2,2,2,2,2,2,2,2,2,2,2,4,4,4,4,4);

TYPE HSC_Song = RECORD
                  Song     : POINTER;
                  SongSize : WORD;
                  FileName : STRING;
                  SongOK   : BOOLEAN;
                END;
     HSC_Info = ARRAY [0..39] OF BYTE;

VAR Musik   : HSC_Song;
    Info    : HSC_Info;
    I, J    : WORD;
    HeadPtr : WORD ABSOLUTE $40:$1A;
    TailPtr : WORD ABSOLUTE $40:$1C;

{$F+}
{$L HSCOBJ.OBJ}
PROCEDURE _HscPlayer; EXTERNAL;
{$F-}

{$L Screen.OBJ}
PROCEDURE Screen; EXTERNAL;

PROCEDURE StartMusic (Song : POINTER; Polling, OldIRQ : BOOLEAN); ASSEMBLER;
  ASM
    MOV  AH,0
    MOV  BL,Polling
    MOV  BH,OldIRQ
    CMP  BH,1
    JE   @Invert
    MOV  BH,1
    JMP  @GoOn
  @Invert:
    XOR  BH,BH
  @GoOn:
    LES  SI,DWORD PTR Song
    CALL _HscPlayer
  END;

PROCEDURE PollMusic; ASSEMBLER;
  ASM
    MOV  AH,1
    CALL _HscPlayer
  END;

PROCEDURE StopMusic; ASSEMBLER;
  ASM
    MOV  AH,2
    CALL _HscPlayer
  END;

PROCEDURE FadeMusic; ASSEMBLER;
  ASM
    MOV  AH,3
    CALL _HscPlayer
  END;

FUNCTION  DetectAdlib (SuggestedPort : WORD) : WORD; ASSEMBLER;
  ASM
    MOV  AH,4
    MOV  BX,SuggestedPort
    CALL _HscPlayer
    JNC  @GoOn
    MOV  AX,0FFh
  @GoOn:
  END;

PROCEDURE ToggleRasterBar; ASSEMBLER;
  ASM
    MOV  AH,5
    CALL _HscPlayer
  END;

PROCEDURE SetUserIRQ (Link : BOOLEAN; Routine : POINTER); ASSEMBLER;
  ASM
    PUSH DS
    MOV  AH,6
    MOV  BL,Link
    LDS  DX,DWORD PTR Routine
    CALL _HscPlayer
    POP  DS
  END;

PROCEDURE GetPlayerState (VAR Destination); ASSEMBLER;
  ASM
    MOV  AH,7
    LES  SI,DWORD PTR Destination
    CALL _HscPlayer
  END;

PROCEDURE LoadSong (VAR Dest : HSC_Song);
  VAR F : FILE;
  BEGIN
    ASSIGN (F,Dest.Filename);
    {$I-} RESET (F,1); {$I+}
    IF IORESULT <> 0
      THEN Dest.SongOK := FALSE
      ELSE
        BEGIN
          Dest.SongSize := FILESIZE (F);
          GETMEM (Dest.Song,Dest.SongSize);
          BLOCKREAD (F,Dest.Song^,Dest.SongSize);
          Dest.SongOK := TRUE;
          CLOSE (F)
        END
  END;

PROCEDURE ClearSong (VAR Dest : HSC_Song);
  BEGIN
    Dest.SongOK := FALSE;
    FREEMEM (Dest.Song,Dest.SongSize);
    Dest.SongSize := 0
  END;

PROCEDURE CursorOn; ASSEMBLER;
  ASM
    MOV  AH,1
    MOV  CH,12
    MOV  CL,13
    INT  10h
  END;

PROCEDURE CursorOff; ASSEMBLER;
  ASM
    MOV  AH,1
    MOV  CH,32
    MOV  CL,32
    INT  10h
  END;

PROCEDURE WriteTitle;
  BEGIN
    TEXTMODE (CO80+FONT8X8);
    CursorOff;
    MOVE (@Screen^,MEM[$B800:0000],8000);
  END;

PROCEDURE WriteTextInfo;
  BEGIN
    FOR I := 0 TO 8 DO     { Equalizer correction }
      IF Info[I+18] = 255 THEN Info[I+18] := 0;
    TEXTCOLOR (LIGHTGRAY);
    FOR I := 0 TO 8 DO
      BEGIN
        GOTOXY (43+I*4,17);
        WRITE (Info[I]:3);
      END;
    FOR I := 0 TO 8 DO
      BEGIN
        GOTOXY (43+I*4,19);
        WRITE (Info[I+9]:3);
      END;
    FOR I := 0 TO 8 DO
      BEGIN
        GOTOXY (43+I*4,21);
        WRITE (Info[I+18]:3);
      END;
    FOR I := 0 TO 8 DO
      BEGIN
        GOTOXY (43+I*4,23);
        WRITE (Info[I+27]:3);
      END;
    GOTOXY (18,17);
    WRITE (Info[36]:3);
    GOTOXY (18,19);
    WRITE (Info[37]:3);
    GOTOXY (18,21);
    WRITE (Info[38]:3);
    GOTOXY (18,23);
    WRITE (Info[39]:3);
    FOR I := 0 TO 8 DO
      BEGIN
        GOTOXY (17,29+I);
        IF Info[I+18] <> 0
          THEN
            FOR J := 0 TO Info[I+18] DO
              BEGIN
                TEXTCOLOR (EqColors[J]);
                WRITE (' ');
              END
          ELSE WRITE ('      ');
        IF J = 15
          THEN WRITE (' ')
          ELSE WRITE ('   ');
      END;
  END;

BEGIN
  IF PARAMCOUNT = 1
    THEN
      BEGIN
        Musik.FileName := PARAMSTR (1);
        LoadSong (Musik);
        IF Musik.SongOK
          THEN
            BEGIN
              WriteTitle;
              TEXTCOLOR (WHITE);
              GOTOXY (34-LENGTH(Musik.FileName),8);
              WRITE (Musik.FileName);
              GOTOXY (29,10);
              WRITE (Musik.SongSize:5);
              StartMusic(Musik.Song,FALSE,TRUE);
              REPEAT
                GetPlayerState (Info);
                WriteTextInfo;
              UNTIL (HeadPTR <> TailPTR);
              HeadPTR := TailPTR;
              StopMusic;
              TEXTMODE (CO80);
              WRITELN ('HSC-Player 1.4 (Pascal-Implementation) by Iron Eagle / ScrapHeap');
              WRITELN ('Have a nice dos...');
            END
          ELSE
            BEGIN
              WRITELN ('ERROR: Couldn''t find the specified file!');
            END;
        ClearSong (Musik);
      END
    ELSE
      BEGIN
        TEXTMODE (CO80);
        WRITELN ('HSC-Player 1.4 (Pascal-Implementation) by Iron Eagle / ScrapHeap');
        WRITELN ('ERROR: Syntax is PLAYHSC filename.hsc !');
      END;
  CursorOn;
END.
