-- Guide to Purchasing the Complete Edition of Euphoria
-- written by Junko C. Miura of Rapid Deployment Software
-- If you have trouble running this program, send e-mail to JCMiura@aol.com

include get.e
include graphics.e
include image.e

-- prices
constant COMPLETE = 32,
	 MANUAL = 7,
	 NA = 5,
	 OVERSEAS = 10,
	 DISCOUNT = 20

function string(integer amount)
    return sprintf("%d", amount)
end function

constant COMPLETE_ = string(COMPLETE),
	 MANUAL_ = string(MANUAL),
	 NA_ = string(NA),
	 OVERSEAS_ = string(OVERSEAS),
	 DISCOUNT_ = string(DISCOUNT)

constant strEsc = 
 "Fill in or change the above information. &Epress 'Esc' key when " &
 "finished&7"

constant strGreeting0 =
 "\n\nYou will be asked several questions in the following menu screens. " &
 "Whether you are registering for the first time, or upgrading, " & 
 "this tool will select the most " &
 "convenient way for you to order the Complete Edition " &
 "of Euphoria. " &
 "If you want to change any of your choices, you can always " &
 "run this program again."

constant strGreeting = 
 "The Complete Edition of Euphoria sells for just $" & COMPLETE_ &
 " plus $" & NA_ & " shipping and handling ($" &
 OVERSEAS_ & " overseas). " &
 "A printed manual is optional at just $" & MANUAL_ & ". " &
 "The total price with shipping, taxes and manual would be " &
 "$" & string(COMPLETE+MANUAL+NA) & " (USA or Canada) or $" &
 string(COMPLETE+MANUAL+OVERSEAS) & " (overseas). " &
 "\n\nIf you have purchased the Complete Edition previously, " &
 "you are eligible for a special upgrade discount of $" &
 DISCOUNT_ & " off the total price." &
 "\n\nIf you have access to the World Wide Web and you don't require " &
 "a printed manual or receipt, you can " &
 "&4save the shipping and handling cost&7. " &
 "\n\n&3All prices are in U.S. dollars.&7" &
 "\n\nThe manual is desktop-published, 8.5\" x 5.5\", " &
 "150 pages with \"Cerlox\" binding. " & 
 "It has nice readable fonts, bold-face etc. It contains exactly the " &
 "same information as REFMAN.DOC and LIBRARY.DOC combined."

constant strCS =
 "\t\t&DOrdering through CompuServe\n\t\t---------------------------&7" &
 "\n\nUsing CompuServe, you can purchase the Complete " & 
 "Edition of Euphoria online.\n\nJust &4GO SWREG" &
 " &7then choose &4option 2 &7- register shareware. \nSearch for " &
 "&4EUPHORIA&7, or specify Registration &4ID # 1391&7." &
 "\n\nThe charge will be $" & string(COMPLETE + MANUAL) & " U.S. plus $"
 
constant strCS1 =
 " shipping and handling. " &
 "\n\nAfter you confirm " &
 "your request, Rapid Deployment Software will be immediately notified, " &
 "and will ship you the latest Complete Edition plus " &
 "printed manual. \n\n$" 
 
constant strCS2 =
 ".00 U.S. will be added to your monthly CompuServe bill. " &
 "If for any reason you " &
 "fail to receive the Complete Edition in a reasonable time, you can ask " &
 "for your money back from CompuServe. \n\nThe version number " &
 "listed on CompuServe may " &
 "be out of date -- don't worry -- we will ship you our latest version, " & 
 "i.e. v1.5a or later.\n\n"

constant strCC1 = 
 "\t&DOrdering through Public software Library (PsL)\n" &
 "\t----------------------------------------------&7\n\n" &
 "You can order Euphoria from Public software Library (PsL) using your " & 
 "&4MasterCard, Visa, American Express or Discovery Card&7." &
 "\n\nEuphoria is listed as product number&4 11109&7"

constant strCC2 = 
 "\n\n&DOr, you can order " & 
 "Euphoria online from PsL by filling out " &
 "PsL's Euphoria order form on the Web.&7" &
 "\n\nFor details go to the Euphoria Web page:\n\n\t" &
 "&3http://members.aol.com/FilesEu/ &7"
 
constant strCC3 = 
 "\t\t&DOrdering through PsL (continued)\n" &
 "\t\t--------------------------------&7\n\n" &
 "You will be sent the latest Complete Edition of Euphoria plus printed " &  
 "manual. The charge will be $" & string(COMPLETE + MANUAL) & 
 " U.S. plus $"
 
constant strCC4 = 
 " shipping and handling. \n&4PsL phone numbers are for ordering only. " &
 "For technical assistance, volume discounts, or any other enquiries " &
 "please contact Rapid Deployment Software directly.&7 " &
 "\n\nWhether you call, FAX or use the Web, PSL will need to know the " &
 "following:" &
 "\n\t- your name " &
 "\n\t- your complete mailing address for shipping Euphoria " &
 "\n\t- Euphoria's product number (11109) " &
 "\n\t- your credit card number, expiry date and name on the card " &
 "\n\t- the fact that you are willing to pay $" 
 
constant strCC5 =
 ".00 U.S. " &
 "\n\t- you should also indicate that you want one copy of Euphoria " &
 "\n\t  (unless you want to order multiple copies)\n\n"

constant strRDS0 =
 "\t&DOrdering directly from Rapid Deployment Software (continued)\n" &
 "\t------------------------------------------------------------&7" 

constant strRDSGreet =
 "\t&DOrdering directly from Rapid Deployment Software\n" &
 "\t------------------------------------------------&7" &
 "\n\n&4You can order by postal mail directly from " & 
 "Rapid Deployment Software.&7" &
 "\n\nYou need to send an order form to RDS by postal mail. \n\nNext, you " &
 "will be asked some questions, so we can create an order form " &
 "for you. Send this order form to RDS when you decide to register." &
 "\n\nFor your convenience, you can print the file &EMYORDER.FRM&7 " &
 "and send it along with your check or money order. If you don't " &
 "have a printer, just copy the essential information to a sheet of paper."

constant strRDSWeb =
 strRDS0 &
 "\n\n&4Since you have access to the World Wide Web and you " &
 "don't need a printed manual or receipt, you can simply download " &
 "the Euphoria Complete Edition from our Web site. You will avoid " &
 "all shipping and handling costs.&7 " 
  
constant strRDSUpgrade =
 strRDS0 & 
 "\n\nSince you have previously purchased the Complete Edition of " &
 "Euphoria, you can upgrade to v1.5a and get a large discount of $" &
 DISCOUNT_ & ".00 U.S. \n\nYou must mail us the order form " &
 "&EMYORDER.FRM&7 that you generate from this tool " &
 "along with your check. &4You can't get the discount via CompuServe " &
 "or PsL.&7 " 

constant strRDSFormNotice0 =
 "\n\n&3Please make sure that the following data is correct.&7\n\n"

constant strRDSOrder = 
 "\n         Euphoria Complete Edition Order Form v1.5a (or later)" &
 "\n         -----------------------------------------------------" &
 "\n\n Enclose a check or money order payable to:\n" &
 "      Rapid Deployment Software\n" &
 "      130 Holm Crescent\n" &
 "      Thornhill, Ontario\n" &
 "      L3T 5J3\n" &
 "      CANADA\n\n\n" &
 " Ship Euphoria to:\n\n"

constant strRDSFormNotice =
 strRDS0 & 
 "\n\n&EMYORDER.FRM&7 has been created in the current directory. " &
 "&4You can print it and send it with a check or money order to RDS " &
 "when you are ready.&7 If you don't have a printer, just copy the " &
 "essential information to a sheet of paper." &
 "\n\n&3The total cost is U.S. $"
 
constant strRDSFormNotice1 =
 "\n\n&3We can accept a personal check or money order " &
 "\n\t\tin your country's currency, or " &
 "\n\t\tin Canadian dollars, or " &
 "\n\t\tin U.S. dollars." &
 "\n\nPlease do a fair conversion from the U.S. dollar price.&7 "

constant strRDSFormNotice2 =
 "\n\n&3You can make a check or money order at your bank or " &
 "post office. Please make it in either U.S. dollars, or preferably " &
 "in Canadian dollars.&7"

constant strRDSCheck =  
 strRDS0 & 
 "\n\nMake your check or money order payable to: " &
 "\n\n\t    &4Rapid Deployment Software&7 " &
 "\n\n\t    130 Holm Crescent " &
 "\n\t    Thornhill, Ontario " &
 "\n\t    L3T 5J3 " &
 "\n\t    CANADA " &
 "\n\n\t    Phone (905) 764-8636 " &
 "\n\t    Fax   (905) 764-7615\n\n"

--****************************************************************************
constant TRUE = 1, FALSE = 0, SCREEN = 1 
constant CR = 13, BS = 8, TAB = 9, ARROW_LEFT = 331, ARROW_RIGHT = 333, 
	 ARROW_UP = 328, ARROW_DOWN = 336, ESC = 27, DELETE = 339,
	 FORM_FEED = 12
constant USA = 'U', CANADA = 'C', OTHER = 'O'
constant YES = 'Y', NO = 'N'

-- field types and indices of the various fields for the menu screen
constant STRING = 1, NUMERIC = 2
constant PROMPT = 1,
	 DATA_TYPE = 2,
	 LINE = 3,
	 COLUMN = 4,
	 DATA_COLUMN = 5,
	 LENGTH = 6,
	 MAX_COLUMN_NO = 7, -- cursor can come, but no entry in THIS column
	 DEFAULT_VALUE = 8,
	 UNIT_PRICE = 9
    
constant FINISH = 0, UP = 1, DOWN = 2


sequence fields -- fields info for the menu screen, definition comes later
sequence input_values   -- user response to fields

integer COUNTRY_INDEX, EMAIL_INDEX, MANUAL_INDEX, UPGRADE_INDEX,
	SHIPPING_INDEX
    -- field specific variables and constants finish here

integer screenWidth, maxNumLines, numColumns, monoMonitor
integer country, isUpgrade, getManual, haveCServe, haveCC, haveWeb
integer countryOk, webPurchase, totalPrice, printNow


function indexLastNonBlankChar(sequence str)
    integer allBlanks, i
    
    i = length(str)
    allBlanks = TRUE
    while allBlanks and i >= 1 do
	if str[i] = ' ' then
	    i = i - 1
	else
	    allBlanks = FALSE
	end if
    end while
    return i
end function


procedure set_color(integer color)
    if monoMonitor then
	return
    else
	text_color(color)
    end if
end procedure


procedure waitResponse(integer key, sequence str)
-- wait for the key response indicated by a parameter   
    integer char
    
    position(maxNumLines, screenWidth - length(str))
    puts(SCREEN,str) 
    while TRUE do
	char = wait_key()
	if char = key then
	    clear_screen()
	    exit
	end if
    end while
end procedure


function upper_key()
    integer char
    object line
    
    line = gets(0)
    if sequence(line) then
	char = line[1]
    else
	char = CR
    end if
    if char >= 'a' and char <= 'z' then
	char = char + 'A' - 'a'
    end if
    return char
end function


procedure color_puts(integer color, object x)
    set_color(color)
    puts(SCREEN, x)
    set_color(WHITE)
end procedure


procedure display(sequence paragraph)
-- neatly display some multi-colored text
    integer column, i

    column = 1
    i = 1
    while i <= length(paragraph) do
	if paragraph[i] = '\n' then
	    puts(SCREEN, paragraph[i])
	    column = 1
	elsif paragraph[i] = '&' then
	    set_color(find(paragraph[i+1], "0123456789ABCDEF")-1)
	    i = i + 1
	else    
	    puts(SCREEN, paragraph[i])
	    column = column + 1
	    if column > numColumns and 
		(paragraph[i] = ' ' or paragraph[i] = '-') then
		puts(SCREEN, '\n')
		column = 1
	    end if
	end if
	i = i + 1
    end while
end procedure


procedure greetings()
    sequence vc
    
    vc = video_config()
    monoMonitor = not vc[VC_COLOR]
    screenWidth = vc[VC_COLUMNS]
    numColumns = screenWidth - 15
    maxNumLines = vc[VC_LINES]
    clear_screen()
    color_puts(BRIGHT_MAGENTA, "\n\tHow to Register for the Complete " &
		"Edition of Euphoria\n\t-----------------------------" &
		"-----------------------\n\n")
    display(strGreeting0)
    waitResponse(CR, "press 'Enter' for NEXT")
    color_puts(BRIGHT_MAGENTA, "\n\tHow to Register for the Complete " &
		"Edition of Euphoria\n\t-----------------------------" &
		"-----------------------\n\n")
    display(strGreeting)
    waitResponse(CR, "press 'Enter' for NEXT")
end procedure


function ask(sequence str)
    integer i
    sequence choices, pos 
    
    choices = {}
    i = 1
    while i <= length(str) do
	if str[i] = '&' then
	    i = i + 1           -- note i is incremented here by one already
	    color_puts(YELLOW, str[i])
	    if str[i] != '_' then
		choices = choices & str[i] 
	    end if
	else
	    puts(SCREEN, str[i])
	end if
	i = i + 1               -- increment i
    end while
    
    if length(choices) > 0 then
	pos = get_position()
	position(pos[1], pos[2] - 1)
	while TRUE do
	    i = find(upper_key(), choices) 
	    if i != 0 then
		return choices[i]
	    else 
		puts(SCREEN, "\nPlease enter ")
		for j = 1 to length(choices) - 2 do
		    color_puts(YELLOW, choices[j])
		    puts(SCREEN, ", ")
		end for
		color_puts(YELLOW, choices[length(choices) - 1])
		puts(SCREEN, " or ")
		color_puts(YELLOW, choices[length(choices)])
		puts(SCREEN, ':')
	    end if
	end while
    end if
end function


procedure cServe()
    clear_screen()
    if country = USA or country = CANADA then
	display(strCS & NA_ & strCS1 & 
		string(COMPLETE+MANUAL+NA) & strCS2)
    else
	display(strCS & OVERSEAS_ & strCS1 & 
		string(COMPLETE+MANUAL+OVERSEAS) & strCS2)
    end if
end procedure


procedure CCard()
    clear_screen()
    display(strCC1)
    if country = USA then
	display("\n\nCall toll-free&4 800-242-4PSL&7, " &
		"or FAX them at&4 713-524-6398&7") 
    elsif country = CANADA then
	display("\n\nYou can call them at&4 713-524-6394 &7" &
		"\n      or FAX them at&4 713-524-6398&7")
    else
	display("\n\nYou can call them at &4U.S.A. 713-524-6394 &7" &
		"\n      or FAX them at &4U.S.A. 713-524-6398&7")
    end if
    if haveWeb = YES then
	display(strCC2)
    end if
    waitResponse(CR, "press 'Enter' for NEXT")
    
    if country = USA or country = CANADA then
	display(strCC3 & NA_ & strCC4 & 
		string(COMPLETE+MANUAL+NA) & strCC5)
    else
	display(strCC3 & OVERSEAS_ & strCC4 & 
		string(COMPLETE+MANUAL+OVERSEAS) & strCC5)
    end if
end procedure


procedure displayFields()
    sequence fieldInsert

    -- define the description of the various fields for the menu screen
    COUNTRY_INDEX = 7       -- these are indices into fields, better NOT
    EMAIL_INDEX = 8         --   to be constants
    MANUAL_INDEX = 10
    UPGRADE_INDEX = 11      -- note that UPGRADE_INDEX and SHIPPING_INDEX are
    SHIPPING_INDEX = 11     --   the same value
    
    fields = 
	{
	  {"Your Name",       STRING,  5, 7, 27, 35, screenWidth, "", ""},
	  {"Your Address",    STRING,  7, 7, 27, 35, screenWidth, "", ""},
	  {"",                STRING,  8, 7, 27, 35, screenWidth, "", ""},
	  {"",                STRING,  9, 7, 27, 35, screenWidth, "", ""},
	  {"",                STRING, 10, 7, 27, 35, screenWidth, "", ""},
	  {"",                STRING, 11, 7, 27, 35, screenWidth, "", ""},
	  {"Country",         STRING, 12, 7, 27, 30, screenWidth, "", ""},
	  {"E-mail address",  STRING, 14, 7, 27, 35, screenWidth, "", ""},
	  {"Complete Edition software    @  $" & sprintf("%2d.00", COMPLETE),  
			      NUMERIC, 18, 7, 51, 2, 53, "1", COMPLETE},
	  {"printed manual               @  $" & sprintf("%2d.00", MANUAL), 
			      NUMERIC, 19, 7, 51, 2, 53, "1", MANUAL},
	  {"shipping/handling            @  $",
			      NUMERIC, 20, 7, 51, 2, 53, "1", NA}
	}

    fieldInsert =
	  {"upgrade discount             @ -$" & sprintf("%2d.00", DISCOUNT),
			      NUMERIC, 20, 7, 51, 2, 53, "1", -DISCOUNT}
    
    if country = USA then
	fields[COUNTRY_INDEX][DEFAULT_VALUE] = "U.S.A."
	fields[SHIPPING_INDEX][PROMPT] = fields[SHIPPING_INDEX][PROMPT] &
					 sprintf("%2d.00", NA)
    elsif country = CANADA then
	fields[COUNTRY_INDEX][DEFAULT_VALUE] = "CANADA"
	fields[SHIPPING_INDEX][PROMPT] = fields[SHIPPING_INDEX][PROMPT] &
					 sprintf("%2d.00", NA)
    else
	fields[SHIPPING_INDEX][PROMPT] = fields[SHIPPING_INDEX][PROMPT] &
					 sprintf("%2d.00", OVERSEAS)
	fields[SHIPPING_INDEX][UNIT_PRICE] = OVERSEAS
    end if
    
    if getManual = NO then
	fields[MANUAL_INDEX][DEFAULT_VALUE] = "0"
    end if
    
    if isUpgrade = YES then
	fields = append(append(fields[1..MANUAL_INDEX], fieldInsert),
			fields[SHIPPING_INDEX])
	SHIPPING_INDEX = SHIPPING_INDEX + 1
	fields[SHIPPING_INDEX][LINE] = fields[SHIPPING_INDEX][LINE] + 1
    end if
    
    if webPurchase = YES then
	fields[SHIPPING_INDEX][DEFAULT_VALUE] = "0"
    end if
    
    clear_screen()
    color_puts(BRIGHT_MAGENTA, "\tOrdering directly from Rapid " &
			       "Deployment Software (continued)\n\t-----" &
			       "----------------------------------------" &
			       "---------------")
    -- display all the prompts
    for i = 1 to length(fields) do
	position(fields[i][LINE], fields[i][COLUMN])
	puts(SCREEN, fields[i][PROMPT])
	position(fields[i][LINE], fields[i][DATA_COLUMN])
	puts(SCREEN, repeat('_', fields[i][LENGTH]))
	position(fields[i][LINE], fields[i][DATA_COLUMN])
	puts(SCREEN, fields[i][DEFAULT_VALUE])
    end for
    position(17, 7)
    color_puts(RED, "description                      price   quantity\n")
end procedure


function key_gets(integer fieldNo)
   integer line, init_column, column, indicator, char, maxColNo, num, num1
   sequence cursor, temp, temp1
   
   cursor = get_position()
   line = cursor[1]
   init_column = cursor[2]
   maxColNo = fields[fieldNo][MAX_COLUMN_NO]
   column = init_column
   while TRUE do
	char = wait_key()
	
	if char = CR or char = TAB or char = ARROW_DOWN then
	    indicator = DOWN
	    exit
	
	elsif char = ARROW_UP then
	    indicator = UP
	    exit

	elsif char = ESC then
	    indicator = FINISH
	    exit
	
	elsif char = DELETE then
	    if column >= init_column and column < maxColNo then
		temp = save_text_image({line, column + 1},
				       {line, maxColNo - 1}) 
		temp = temp[1]          -- temp now is a single sequence
		temp1 = ""
		for j = 1 to length(temp) - 1 by 2 do
		    temp1 = append(temp1, temp[j])
		end for
		temp1 = temp1[1..indexLastNonBlankChar(temp1)]
		puts(SCREEN, temp1)
		num = fields[fieldNo][DATA_COLUMN] + fields[fieldNo][LENGTH]
		num1 = column + length(temp1)
		if num1 < num then      -- num1 is a cursor column position
		    puts(SCREEN, repeat('_', num - num1))
		else
		    puts(SCREEN, repeat(' ', maxColNo - num1))
		end if
		position(line, column)
	    end if
	
	elsif char = ARROW_RIGHT then
	    if column < maxColNo then
		column = column + 1
		position(line, column)
	    end if
	    
	elsif char = BS then
	    if column > init_column then
		if column < maxColNo then
		    temp = save_text_image({line, column}, 
					   {line, maxColNo - 1}) 
		    temp = temp[1]          -- temp now is a single sequence
		    temp1 = ""
		    for j = 1 to length(temp) - 1 by 2 do
			temp1 = append(temp1, temp[j])
		    end for
		    temp1 = temp1[1..indexLastNonBlankChar(temp1)]
		    column = column - 1
		    position(line, column)
		    puts(SCREEN, temp1)
		    num = fields[fieldNo][DATA_COLUMN] + 
			  fields[fieldNo][LENGTH]
		    num1 = column + length(temp1)
		    if num1 < num then      -- num1 is a cursor column position
			puts(SCREEN, repeat('_', num - num1))
		    else
			puts(SCREEN, repeat(' ', maxColNo - num1))
		    end if
		    position(line, column)
		elsif column = maxColNo then
		    column = column - 1
		    position(line, column)
		end if
	    end if
	    
	elsif char = ARROW_LEFT then
	    if column > init_column then
		column = column - 1
		position(line, column)
	    end if
	    
	elsif char >= 32  and char <= 255 then
	    if column < maxColNo then
		puts(SCREEN, char)
		column = column + 1
	    end if
	
	end if
    end while
    return indicator
end function


procedure get_data()
-- get field values from user and return them as a sequence
    integer fieldNo, keyResults
    sequence temp, temp1

    displayFields()
    position(maxNumLines, screenWidth - length(strEsc))
    display(strEsc) 
    
    -- let the user enter all data
    fieldNo = 1
    while TRUE do
	position(fields[fieldNo][LINE], fields[fieldNo][DATA_COLUMN])
	keyResults = key_gets(fieldNo)
	if keyResults = DOWN then
	    if fieldNo < length(fields) then
		fieldNo = fieldNo + 1
	    else
		fieldNo = 1
	    end if
	
	elsif keyResults = UP then
	    if fieldNo > 1 then
		fieldNo = fieldNo - 1
	    end if
	
	elsif keyResults = FINISH then
	    exit

	end if
    end while
    
    -- collect all the input
    input_values = repeat("", length(fields))
    totalPrice = 0
    for i = 1 to length(fields) do
	temp = save_text_image({fields[i][LINE], fields[i][DATA_COLUMN]},
			 {fields[i][LINE], fields[i][MAX_COLUMN_NO] - 1})
	temp = temp[1]
	for j = 1 to length(temp) - 1 by 2 do
	    if temp[j] = '_' then
		temp[j] = ' '
	    end if
	    input_values[i] = append(input_values[i], temp[j])
	end for
	
	if fields[i][DATA_TYPE] = NUMERIC then
	    temp = value(input_values[i])
	    if temp[1] = GET_SUCCESS then
		input_values[i] = temp[2]
	    elsif temp[1] = GET_EOF then    -- nothing in the field
		input_values[i] = 0
	    else        -- non-numeric data in the field. Assign a default.
		temp1 = value(fields[i][DEFAULT_VALUE])
		input_values[i] = temp1[2]
	    end if
	    totalPrice = totalPrice + input_values[i] * fields[i][UNIT_PRICE]
	end if
    end for
    if input_values[MANUAL_INDEX] > 0 and 
       input_values[SHIPPING_INDEX] = 0 then
	input_values[SHIPPING_INDEX] = 1
	totalPrice = totalPrice + fields[SHIPPING_INDEX][UNIT_PRICE]
    end if
end procedure


procedure displayCost()
    integer fn, k, totalCadPrice
    
    clear_screen()
    display(strRDSFormNotice0)
    -- display data for user's check on the screen here, then create a file
    fn = open("myorder.frm", "w")
    if fn = -1 then
	display("Can't create MYORDER.FRM ! We will abort execution.")
	abort(1)
    end if
    for j = 1 to 2 do
	if j = 1 then
	    k = SCREEN
	else
	    k = fn
	    puts(k, strRDSOrder)
	end if
	for i = 1 to length(input_values) do
	    if fields[i][DATA_TYPE] = NUMERIC then
		printf(k, " %-49s%d\n", {fields[i][PROMPT], input_values[i]})
	    elsif i = EMAIL_INDEX then
		printf(k, "\n %-20s%s\n\n\n", 
		       {fields[i][PROMPT], input_values[i]})
		puts(k, " description                      price   " &
			"    quantity\n")
		puts(k, " -------------------------        -----   " &
			"    --------\n")
	    else 
		printf(k, " %-20s%s\n", {fields[i][PROMPT], input_values[i]})
	    end if
	end for
	printf(k, "%61s\n\n", {"----------------------------"})
	printf(k, "%40s%5d.00 %s\n", {"Total:", totalPrice, "U.S. dollars"})
	
	if country != USA then
	    totalCadPrice = floor(totalPrice * 1.3)
	    printf(k, "%40s%d.00 %s\n", {"(We will also accept ",
					  totalCadPrice, "Canadian dollars)"})
	end if
	puts(k, "\n\n")
    end for
	
    if input_values[SHIPPING_INDEX] = 0 then
	puts(fn, "\n You will download the Complete Edition software " &
		"from the \n World Wide Web. Send e-mail to 72614.1667" &
		"@compuserve.com \n and we will give you the necessary " &
		"instructions. Nothing \n will be shipped to you by postal" &
		" mail.\n\n")
    end if
    close(fn)
    
    waitResponse(CR,"press 'Enter' for NEXT")
    display(strRDSFormNotice)
    printf(SCREEN, "%d.00", totalPrice)     -- printed in some bright color
    if country != USA then
	printf(SCREEN, " (or %d.00 Canadian dollars)", totalCadPrice) 
    end if
    set_color(WHITE)                        -- change back the forground color
    if country = OTHER then
	if countryOk = YES then
	    display(strRDSFormNotice1)
	else
	    display(strRDSFormNotice2)
	end if
    end if
    waitResponse(CR, "press 'Enter' for NEXT")
end procedure


procedure printRDSOrder()
    integer p, of, tryAgain
    object line
    
    puts(SCREEN, "\n\nPress any key when your printer is ready.")
    if wait_key() then
    end if
    p = open("PRN", "w")
    if p = -1 then
	color_puts(RED, "\n\ncould not open printer. Make sure it " &
			"is on and connected.")
	tryAgain = ask("\n\nWould you like to try again? &Yes or &No &_")
	if tryAgain = YES then
	    p = open("PRN", "w")
	    if p = -1 then
		color_puts(RED, "\n\nStill can't open printer. You can " &
				"print MYORDER.FRM file at a later time.")
		waitResponse(CR, "press 'Enter' for NEXT")
		return
	    end if
	else
	    return
	end if
    end if
    of = open("myorder.frm", "r")
    if of = -1 then
	display("\n\nCan't open MYORDER.FRM !")
	waitResponse(CR, "press 'Enter' for NEXT")
	return
    end if

    while TRUE do
	line = gets(of)
	if atom(line) then
	    exit
	end if
	puts(p, line)
    end while
    puts(p, FORM_FEED)
    close(p)
    close(of)
end procedure


procedure RDSOrder()
    integer create
    
    clear_screen()
    display(strRDSGreet)
    create = ask("\n\nWould you like to create an order form now? " &
		 "&Yes or &No &_")
    clear_screen()
    if create = NO then
	return
    end if
    webPurchase = NO
    if haveWeb = YES and getManual = NO then
	display(strRDSWeb)
	webPurchase = ask("\n\nDo you want to take this option? &Yes " &
			  "or &No &_")
    end if
    countryOk = YES
    if country = OTHER then
	clear_screen()
	color_puts(BRIGHT_MAGENTA, "\tOrdering directly from Rapid " &
		   "Deployment Software (continued)\n\t------------" &
		   "------------------------------------------------")
	countryOk = ask("\n\nDo you live in one of the following " &
		"\n\tcountries?\n\n\t" &
		"\n\tAustralia,   Austria,     Barbados,    Belgium, " &
		"\n\tBritain,     Canada,      Denmark,     Finland, " &
		"\n\tFrance,      Greece,      Germany,     Hong Kong, " &
		"\n\tIreland,     Italy,       Japan,       Mexico, " &
		"\n\tNetherlands, New Zealand, Norway,      Portugal, " &
		"\n\tSpain,       Sweden,      Switzerland, United States" &
		"\n\n\t\t&Yes or &No &_")
    end if

    clear_screen()
    if isUpgrade = YES then
	display(strRDSUpgrade)
	waitResponse(CR, "press 'Enter' for NEXT")
    end if
    get_data()
    displayCost()
    display(strRDS0)
    printNow = ask("\n\nWould you like to print your order form right " &
		   "now? &Yes or &No &_")
    if printNow = YES then
	printRDSOrder()     
    end if
    clear_screen()
    display(strRDSCheck)
end procedure


-- *** start the main execution part
    greetings()
    country = ask("\nWhich country do you live in, &U.S.A., &Canada " &
		  "or &Other? &_")

    isUpgrade = ask("\n\nHave you previously purchased the Complete " &
		    "Edition of Euphoria? &Yes or &No &_")
    getManual = ask("\n\nDo you want to get a printed manual? &Yes " &
		    "or &No &_")
		    
    haveWeb = ask("\n\nDo you have access to the World Wide Web? &Yes or " &
		  "&No &_")
    
    if isUpgrade = NO and getManual = YES then
	haveCServe = ask("\n\nDo you have a CompuServe account? &Yes or " &
			 "&No &_")
	if haveCServe = YES then
	    cServe()
	else
	    -- keep up-to-date which CCards are accepted by PsL all the time !  
	    haveCC = ask("\n\nDo you have a credit card, such as\n\t\t" &
			 "MasterCard, \n\t\tVisa, \n\t\tAmerican Express " &
			 "or \n\t\tDiscovery Card, \n\tand do you want to " & 
			 "use it? \n\t\t\t&Yes or &No &_")
	    if haveCC = YES then
		CCard()
	    else
		RDSOrder()
	    end if          
	end if
    else
	RDSOrder()
    end if

