unit ModeX;
{============================================================================}
{                     M   M  OOO  DDDD  EEEE       X   X                     }
{                     MM MM O   O D   D E           X X                      }
{                     M M M O   O D   D EEE   ----   X                       }
{                     M   M O   O D   D E           X X                      }
{                     M   M  OOO  DDDD  EEEE       X   X      by Goetz Bock  }
{============================================================================}
{              A complete Mode X Unit for Turbo/Borland Pascal               }
{============================================================================}
{ Based on Matt Pritchard's MODEX.ASM Version 0.95 Beta                      }
{                                                                            }
{ This Unit (and the included OBJ-File is granted to the public domain. You  }
{ may use it on your own risc.                                               }
{ If you do use this code in a product, it would be nice if you include a    }
{ line like "Mode X routines by Matt Pritchard and Goetz Bock" in the credits}
{----------------------------------------------------------------------------}
{ Credits go to Matt Pritchard, Jrgen Petsch and some other persones from   }
{ c't magazine, DOS international and the international 80XXX echo, who made }
{ it possible for me to write this unit.                                     }
{----------------------------------------------------------------------------}

interface
Procedure SET_VGA_MODEX (Mode, MaxXpos, MaxYpos, Pages : integer);
{Sets Up the specified version of Mode X.  Allows for
 the setup of multiple video pages, and a virtual
 screen which can be larger than the displayed screen
 (which can then be scrolled a pixel at a time)
        ModeType = Desired Screen Resolution (0-7)
     0 =  320 x 200, 4 Pages max,   1.2:1 Aspect Ratio
     1 =  320 x 400, 2 Pages max,   2.4:1 Aspect Ratio
     2 =  360 x 200, 3 Pages max,  1.35:1 Aspect Ratio
     3 =  360 x 400, 1 Page  max,   2.7:1 Aspect Ratio
     4 =  320 x 240, 3 Pages max,     1:1 Aspect Ratio
     5 =  320 x 480, 1 Page  max,     2:1 Aspect Ratio
     6 =  360 x 240, 3 Pages max, 1.125:1 Aspect Ratio
     7 =  360 x 480, 1 Page  max,  2.25:1 Aspect Ratio

        MaxXpos = The Desired Virtual Screen Width
        MaxYpos = The Desired Virtual Screen Height
        Pages   = The Desired # of Video Pages}
Procedure SET_MODEX (Mode : integer);
{Quickle Mode Set - Sets Up Mode X to Default Configuration
        ModeType = Desired Screen Resolution (0-7)}
Procedure SET_TEXT;
{Resets Text Mode  [GB]}
Procedure CLEAR_VGA_SCREEN (Color : integer);
{Clears the active display page
        ColorNum = Color Value to fill the page with}
Procedure SET_POINT (Xpos, Ypos, Color : integer);
{Plots a single Pixel on the active display page
        Xpos     = X position to plot pixel at
        Ypos     = Y position to plot pixel at
        ColorNum = Color to plot pixel with}
Procedure MSET_POINT (Xpos, Ypos, Color : integer);
{Plots a single Pixel on the active display page
 Taking care of the WriteMode.
        Xpos     = X position to plot pixel at
        Ypos     = Y position to plot pixel at
        ColorNum = Color to plot pixel with}
Function READ_POINT (Xpos, Ypos : integer) : integer;
{Read the color of a pixel from the Active Display Page
        Xpos = X position of pixel to read
        Ypos = Y position of pixel to read}
Procedure FILL_BLOCK (Xpos1, Ypos1, Xpos2, Ypos2, Color : integer);
{Fills a rectangular block on the active display Page
        Xpos1    = Left X position of area to fill
        Ypos1    = Top Y position of area to fill
        Xpos2    = Right X position of area to fill
        Ypos2    = Bottom Y position of area to fill
        ColorNum = Color to fill area with}
Procedure MFILL_BLOCK (Xpos1, Ypos1, Xpos2, Ypos2, Color : integer);
{Fills a rectangular block on the active display Page
 This one is taking care of the seted Mode (normal, OR, XOR, AND)
        Xpos1    = Left X position of area to fill
        Ypos1    = Top Y position of area to fill
        Xpos2    = Right X position of area to fill
        Ypos2    = Bottom Y position of area to fill
        ColorNum = Color to fill area with  [GB]}
Procedure DRAW_LINE (Xpos1, Ypos1, Xpos2, Ypos2, Color : integer);
{Draws a Line on the active display page
        Xpos1    = X position of first point on line
        Ypos1    = Y position of first point on line
        Xpos2    = X position of last point on line
        Ypos2    = Y position of last point on line
        ColorNum = Color to draw line with}
Procedure DRAW_CIRCLE (Xpos, Ypos, Radius, Color : integer);
{Draws a Circle on the active display page
         Xpos     = X position of center
         Ypos     = Y position of center
         Radius   = radius of circle
         ColorNum = Color to draw circle with  [GB]}
Procedure MDRAW_CIRCLE (Xpos, Ypos, Radius, Color : integer);
{Draws a Circle on the active display page
 This one is taking care of the seted Mode (normal, OR, XOR, AND)
         Xpos     = X position of center
         Ypos     = Y position of center
         Radius   = radius of circle
         ColorNum = Color to draw circle with  [GB]}
Procedure FILL_CIRCLE (Xpos, Ypos, Radius, Color : integer);
{Draws a filled Circle on the active display page
         Xpos     = X position of center
         Ypos     = Y position of center
         Radius   = radius of circle
         ColorNum = Color to draw circle with   [GB]}
Procedure MFILL_CIRCLE (Xpos, Ypos, Radius, Color : integer);
{Draws a filled Circle on the active display page
 This one is taking care of the seted Mode (normal, OR, XOR, AND)
         Xpos     = X position of center
         Ypos     = Y position of center
         Radius   = radius of circle
         ColorNum = Color to draw circle with   [GB]}
Procedure SET_DAC_REGISTER (RegNo, Red, Green, Blue : integer);
{Sets a single (RGB) Vga Palette Register
        Register = The DAC # to modify (0-255)
        Red      = The new Red Intensity (0-63)
        Green    = The new Green Intensity (0-63)
        Blue     = The new Blue Intensity (0-63)}
Procedure GET_DAC_REGISTER (RegNo : Integer; VAR Red, Green, Blue:integer);
{Reads the RGB Values of a single Vga Palette Register
        Register = The DAC # to read (0-255)
        Red      = The Red Intensity (0-63)
        Green    = The Green Intensity (0-63)
        Blue     = The Blue Intensity (0-63)}
Procedure SET_NORMAL_MODE;
{Sets the normal write Mode: All Data is Moved to the Latches  [GB]}
Procedure SET_OR_MODE;
{Sets the OR write Mode: All Data is ORed to the Latches  [GB]}
Procedure SET_XOR_MODE;
{Sets the XOR write Mode: All Data is XORed to the Latches  [GB]}
Procedure SET_AND_MODE;
{Sets the AND write Mode: All Data is ANDed to the Latches  [GB]}
Procedure SET_ACTIVE_PAGE (PageNo : integer);
{Sets the active display Page to be used for future drawing
        PageNo = Display Page to make active
        (values: 0 to Number of Pages - 1)}
Function GET_ACTIVE_PAGE : integer;
{Returns the Video Page # currently used for Drawing}
Procedure SET_DISPLAY_PAGE (PageNo : integer);
{Sets the currently visible display page.
 When called this routine syncronizes the display
 to the vertical blank.
        PageNo = Display Page to show on the screen
        (values: 0 to Number of Pages - 1)}
Function GET_DISPLAY_PAGE : integer;
{Returns the Video Page # currently displayed}
Procedure SET_WINDOW (DisplayPage, XOffset, YOffset : integer);
{Since a Logical Screen can be larger than the Physical
 Screen, Scrolling is possible.  This routine sets the
 Upper Left Corner of the Screen to the specified Pixel.
 Also Sets the Display page to simplify combined page
 flipping and scrolling.  When called this routine
 syncronizes the display to the vertical blank.
        DisplayPage = Display Page to show on the screen
        Xpos        = # of pixels to shift screen right
        Ypos        = # of lines to shift screen down}
Function GET_X_OFFSET : integer;
{Returns the X coordinate of the Pixel currently display
 in the upper left corner of the display}
Function GET_Y_OFFSET : integer;
{Returns the Y coordinate of the Pixel currently display
 in the upper left corner of the display}
Procedure SYNC_DISPLAY;
{Pauses the computer until the next Vertical Retrace starts}
Procedure SET_SPLITTED_SCREEN (Line : word);
{Devides the display screen at Line
 ENTRY: Line = Line to devide at}
Procedure GPRINTC (CharNum : Char; Xpos, Ypos, ColorF, ColorB : integer);
{Draws an ASCII Text Character using the currently selected
 8x8 font on the active display page.
        CharNum = ASCII character # to draw
        Xpos    = X position to draw Character at
        Ypos    = Y position of to draw Character at
        ColorF  = Color to draw text character in
        ColorB  = Color to set background to}
Procedure TGPRINTC (CharNum : Char; Xpos, Ypos, ColorF : integer);
{Transparently draws an ASCII Text Character using the
 currently selected 8x8 font on the active display page.
        CharNum = ASCII character # to draw
        Xpos    = X position to draw Character at
        Ypos    = Y position of to draw Character at
        ColorF  = Color to draw text character in}
Procedure MGPRINTC (CharNum : Char; Xpos, Ypos, ColorF : integer);
{Transparently draws an ASCII Text Character using the
 currently selected 8x8 font on the active display page.
 Takes care of WriteMode.
        CharNum = ASCII character # to draw
        Xpos    = X position to draw Character at
        Ypos    = Y position of to draw Character at
        ColorF  = Color to draw text character in  [GB]}
Procedure PRINT_STR (Text : string; Xpos, Ypos, ColorF, ColorB : integer);
{Routine to quickly Print a null terminated ASCII string on the
 active display page up to a maximum length.
        String  = Far Pointer to ASCII string to print
        MaxLen  = # of characters to print if no null found
        Xpos    = X position to draw Text at
        Ypos    = Y position of to draw Text at
        ColorF  = Color to draw text in
        ColorB  = Color to set background to}
Procedure TPRINT_STR (Text : string; Xpos, Ypos, ColorF : integer);
{Routine to quickly transparently Print a null terminated ASCII
 string on the active display page up to a maximum length.
        String  = Far Pointer to ASCII string to print
        MaxLen  = # of characters to print if no null found
        Xpos    = X position to draw Text at
        Ypos    = Y position of to draw Text at
        ColorF  = Color to draw text in}
Procedure MPRINT_STR (Text : string; Xpos, Ypos, ColorF : integer);
{Routine to quickly transparently Print a null terminated ASCII
 string on the active display page up to a maximum length.
 Takes care of WirteMode
        String  = Far Pointer to ASCII string to print
        MaxLen  = # of characters to print if no null found
        Xpos    = X position to draw Text at
        Ypos    = Y position of to draw Text at
        ColorF  = Color to draw text in  [GB]}
Procedure SET_DISPLAY_FONT (FontData : Pointer; FontNumber : integer);
{Allows the user to specify their own font data for
 wither the lower or upper 128 characters.
        FontData   = Far Pointer to Font Bitmaps
        FontNumber = Which half of set this is
                   = 0, Lower 128 characters
                   = 1, Upper 128 characters}
Procedure DRAW_BITMAP (Image : Pointer; Xpos, Ypos, Width, Height : integer);
{Draws a variable sized Graphics Bitmap such as a
 picture or an Icon on the current Display Page in
 Mode X.  The Bitmap is stored in a linear byte array
 corresponding to (0,0) (1,0), (2,0) .. (Width, Height)
 This is the same linear manner as mode 13h graphics.
        Image  = Far Pointer to Bitmap Data
        Xpos   = X position to Place Upper Left pixel at
        Ypos   = Y position to Place Upper Left pixel at
        Width  = Width of the Bitmap in Pixels
        Height = Height of the Bitmap in Pixels}
Procedure TDRAW_BITMAP (Image : Pointer; Xpos, Ypos, Width, Height : integer);
{Transparently Draws a variable sized Graphics Bitmap
 such as a picture or an Icon on the current Display Page
 in Mode X.  Pixels with a value of 0 are not drawn,
 leaving the previous "background" contents intact.
 The Bitmap format is the same as for the DRAW_BITMAP function.
        Image  = Far Pointer to Bitmap Data
        Xpos   = X position to Place Upper Left pixel at
        Ypos   = Y position to Place Upper Left pixel at
        Width  = Width of the Bitmap in Pixels
        Height = Height of the Bitmap in Pixels}
Procedure MDRAW_BITMAP (Image : Pointer; Xpos, Ypos, Width, Height : integer);
{Draws a variable sized Graphics Bitmap such as a
 picture or an Icon on the current Display Page in
 Mode X.  The Bitmap is stored in a linear byte array
 corresponding to (0,0) (1,0), (2,0) .. (Width, Height)
 This is the same linear manner as mode 13h graphics.
 This one is taking care of the seted Mode (normal, OR, XOR, AND)
        Image  = Far Pointer to Bitmap Data
        Xpos   = X position to Place Upper Left pixel at
        Ypos   = Y position to Place Upper Left pixel at
        Width  = Width of the Bitmap in Pixels
        Height = Height of the Bitmap in Pixels  [GB]}
Procedure COPY_PAGE (SourcePage, DestPage : integer);
{Duplicate on display page onto another
        SourcePage = Display Page # to Duplicate
        DestPage   = Display Page # to hold copy}
Procedure COPY_BITMAP (SourcePage, X1, Y1, X2, Y2,
                       DestPage, DestX1, DestY1 : integer);
{Copies a Bitmap Image from one Display Page to Another
 This Routine is Limited to copying Images with the same
 Plane Alignment.  To Work: (X1 MOD 4) must = (DestX1 MOD 4)
 Copying an Image to the Same Page is supported, but results
 may be defined when the when the rectangular areas
 (X1, Y1) - (X2,Y2) and (DestX1, DestY1) -
 (DestX1+(X2-X1), DestY1+(Y2-Y1)) overlap...
 No Paramter checking to done to insure that
 X2 >= X1 and Y2 >= Y1.  Be Careful...
        SourcePage = Display Page # with Source Image
        X1         = Upper Left Xpos of Source Image
        Y1         = Upper Left Ypos of Source Image
        X2         = Lower Right Xpos of Source Image
        Y2         = Lower Right Ypos of Source Image
        DestPage   = Display Page # to copy Image to
        DestX1     = Xpos to Copy UL Corner of Image to
        DestY1     = Ypos to Copy UL Corner of Image to}

implementation
{$L modeX.obj}
{$F+}
Procedure SET_VGA_MODEX (Mode, MaxXpos, MaxYpos, Pages : integer); external;
Procedure SET_MODEX (Mode : integer); external;
Procedure SET_TEXT; external;
Procedure CLEAR_VGA_SCREEN (Color : integer); external;
Procedure SET_POINT (Xpos, Ypos, Color : integer); external;
Procedure MSET_POINT (Xpos, Ypos, Color : integer); external;
Function READ_POINT (Xpos, Ypos : integer) : integer; external;
Procedure FILL_BLOCK (Xpos1, Ypos1, Xpos2, Ypos2, Color : integer); external;
Procedure MFILL_BLOCK (Xpos1, Ypos1, Xpos2, Ypos2, Color : integer); external;
Procedure DRAW_LINE (Xpos1, Ypos1, Xpos2, Ypos2, Color : integer); external;
Procedure DRAW_CIRCLE (Xpos, Ypos, Radius, Color : integer);external;
Procedure MDRAW_CIRCLE (Xpos, Ypos, Radius, Color : integer);external;
Procedure FILL_CIRCLE (Xpos, Ypos, Radius, Color : integer);external;
Procedure MFILL_CIRCLE (Xpos, Ypos, Radius, Color : integer); external;
Procedure SET_DAC_REGISTER (RegNo, Red, Green, Blue : integer); external;
Procedure GET_DAC_REGISTER (RegNo : integer; Var Red, Green, Blue : integer); external;
Procedure SET_NORMAL_MODE; external;
Procedure SET_OR_MODE; external;
Procedure SET_XOR_MODE; external;
Procedure SET_AND_MODE; external;
Procedure SET_ACTIVE_PAGE (PageNo : integer); external;
Function GET_ACTIVE_PAGE : integer; external;
Procedure SET_DISPLAY_PAGE (PageNo : integer); external;
Function GET_DISPLAY_PAGE : integer; external;
Procedure SET_WINDOW (DisplayPage, XOffset, YOffset : integer); external;
Function GET_X_OFFSET : integer; external;
Function GET_Y_OFFSET : integer; external;
Procedure SYNC_DISPLAY; external;
Procedure SET_SPLITTED_SCREEN (Line : word);external;
Procedure GPRINTC (CharNum : Char; Xpos, Ypos, ColorF, ColorB : integer); external;
Procedure TGPRINTC (CharNum: Char; Xpos, Ypos, ColorF : integer); external;
Procedure MGPRINTC (CharNum: Char; Xpos, Ypos, ColorF : integer); external;
Procedure PRINT_STR (Text : string ; Xpos, Ypos, ColorF, ColorB : integer);
external;
Procedure TPRINT_STR (Text : string; Xpos, Ypos, ColorF : integer); external;
Procedure MPRINT_STR (Text : string; Xpos, Ypos, ColorF : integer); external;
Procedure SET_DISPLAY_FONT (FontData : Pointer; FontNumber : integer); external;
Procedure DRAW_BITMAP (Image : Pointer; Xpos, Ypos, Width, Height : integer); external;
Procedure TDRAW_BITMAP (Image : Pointer; Xpos, Ypos, Width, Height : integer); external;
Procedure MDRAW_BITMAP (Image : Pointer; Xpos, Ypos, Width, Height : integer); external;
Procedure COPY_PAGE (SourcePage, DestPage : integer); external;
Procedure COPY_BITMAP (SourcePage, X1, Y1, X2, Y2,
                       DestPage, DestX1, DestY1 : integer);external;
{$F-}

end.