        name    vsq     ; VGA Sequencer routines
        ;
        ;  void Select_Wplane(int planes);
        ;       planes = bit mask 0=plane 0 write enable, 1=plane 1, etc.
        ;
        ;  void SQset_reg(int reg, int value);
        ;  int  SQread_reg(int reg);
        ;  void SQset_regm(int reg, int value, int bitmask);
        ;  void Vdisable_refresh(void);
        ;  void Venable_refresh(void);
        ;

SEQUENCER_PORT          EQU     03C4h   ;Sequencer
PLANE_ENABLE_REG        EQU     2       ;Write plane enable register

ARG1    equ     [bp+06]
ARG2    equ     [bp+08]
REGNO   equ     [bp+06]
VALUE   equ     [bp+08]
BMASK   equ     [bp+0ah]

SQ_TEXT       segment byte public 'CODE'
        public  _Select_WPlane
        assume  cs:SQ_TEXT
_Select_WPlane   proc    far
        push    bp
        mov     bp,sp
        mov     ah,ARG1
        mov     dx,SEQUENCER_PORT
        mov     al,PLANE_ENABLE_REG
        out     dx,ax
        pop     bp
        ret
_Select_WPlane   endp
        public  _SQread_reg
_SQread_reg   proc    far
        push    bp
        mov     bp,sp
        mov     al,ARG1
        mov     dx,SEQUENCER_PORT
        out     dx,al
        inc     dx
        in      al,dx
        xor     ah,ah
        pop     bp
        ret
_SQread_reg   endp
        public  _SQset_reg
_SQset_reg   proc    far
        push    bp
        mov     bp,sp
        mov     al,ARG1
        mov     ah,ARG2
        mov     dx,SEQUENCER_PORT
        out     dx,ax
        pop     bp
        ret
_SQset_reg   endp
        public  _SQset_regm
_SQset_regm     PROC  far
        push    bp
        mov     bp,sp

        mov     dl,REGNO
        push    dx
        call    _SQread_reg    ; returns al=reg(reg_num);
        add     sp,2

        mov     bl,BMASK
        not     bl        ; !mask
        and     al,bl     ; al=(!mask&reg(reg_num));
        mov     cl,al     ; save for a microsecond
        mov     al,VALUE
        mov     bl,BMASK
        and     al,bl
        or      al,cl     
        push    ax
        mov     al,REGNO
        push    ax
        call    _SQset_reg
        add     sp,4

        xor     ax,ax
        pop     bp
        ret
_SQset_regm     ENDP
        public  _Vdisable_refresh
Old_clk         db    0
_Vdisable_refresh   proc    far
        mov     dx,SEQUENCER_PORT
        mov     al,1
        out     dx,al
        inc     dx
        in      al,dx
        mov     ah,al
        mov     Old_clk,ah
        or      al,20h
        out     dx,al
        ret
_Vdisable_refresh   endp
        public  _Venable_refresh
_Venable_refresh   proc    far
        mov     ah,Old_clk
        and     ah,ah
        jz      retout
        mov     dx,SEQUENCER_PORT
        mov     al,1
        out     dx,ax
retout: ret
_Venable_refresh   endp
SQ_TEXT       ends
        end

