#include <dos.h>
#include <huge.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <mem.h>
#define  VIDLIB
#include "vidlib.h"

int debugtimeson=0;

int Vinit(void)
{
  if ( !_vidinit) {
     ReadDACs(&_olddacs);
     _oldmode=BIOScrtmode;
     _vidinit=1;
  }
  return(_oldmode);
}

void Vclose(void)
{
  if ( _vidinit ) {
     WriteDACs(&_olddacs);
     VGAmode(_oldmode, NULL);
     _vidinit=0;
  }
  return;
}

int   VGAmode(unsigned int mode, char *palette)
{
   if ( (mode <= 0x13) && (mode >= 0)){
       _AH=0;
       _AL=(unsigned short)mode;
       geninterrupt(0x10);
       if (BIOScrtmode != mode) {
          return(0);
       }
       if ( palette != NULL ) {
          if (mode == 0x13) {
             if ( palette == DEFAULTDAC)
                WriteDACs(&_olddacs); /* restore defaults */
             else
                WriteDACs(palette);
          } else {
             Load_Palette(0, 16, palette);
          }
       }
       switch (mode) {
         /* 80 x 25, text mode */
         case 0x03 :  _screen_width=80;
                      _memory_length=409;
                      _screen_length=25;
                      _screen_start=(char *)(0xB8000000L);
                      break;
         case 0x0f :                                /* x 2 planes */
         /* 640 x 200, 1 bit per pixel x 4 planes */
         case 0x0e :  _screen_width=80;
                      _memory_length=819;
                      _screen_length=200;
                      _screen_start=(char *)(0xA0000000L);
                      break;
         /* 320 x 200, 1 bit per pixel x 4 planes */
         case 0x0d :  _screen_width=40;
                      _memory_length=1638;
                      _screen_length=200;
                      _screen_start=(char *)(0xA0000000L);
                      break;
         /* 640 x 350, 1 bit per pixel */
         case 0x10 :  _screen_width=80;             /* x 4 planes */
                      _memory_length=819;
                      _screen_length=350;
                      _screen_start=(char *)(0xA0000000L);
                      break;
         /* 640 x 480, 1 bit per pixel x 4 planes */
         case 0x12 :  _screen_width=80;
                      _memory_length=819;
                      _screen_length=480;
                      _screen_start=(char *)(0xA0000000L);
                      break;
         /* 320 x 200, 1 byte per pixel */
         case 0x13 :  _screen_width=320;
                      _memory_length=204;
                      _screen_length=200;
                      _screen_start=(char *)(0xA0000000L);
                      break;
       }
       if (vgadebug != NULL) {
          sprintf(tdbg,"\nVGAmode: mode=%u, _sw=%u, _sl=%u, _ss=%lx\n",
                       mode, _screen_width, _memory_length, _screen_start);
          fputs(tdbg,vgadebug);
       }
       return(1);
   } else
       return(0);
}

int isVGA(void)
{
   _AX=0x1a00;
   geninterrupt(0x10);
   if ( (_AL == 0x1a )&& (_BL > 7))
      return(1);
   else
      return(0);
}

void Start_vgadebug(char *path)
{
   if (debugtimeson)
      vgadebug=fopen(path,"a");
   else
      vgadebug=fopen(path,"w");
   debugtimeson++;
}

void Close_vgadebug(void)
{
   fclose(vgadebug);
}


