Program CODE; uses DOS, CRT;

{$S-;$R-}
  var
    Disable : boolean;
    OldInt09 : pointer;

  procedure INT09; interrupt;
    type
      HexT = array [$0..$F] of char;
    const
      Hex : HexT = '0123456789ABCDEF';
    var
      Code : byte;
      Ack  : byte;
    begin
      { read keyboard port}
      Code := Port[$60];

      { acknowledge keyboard read }
      Ack  := Port[$61];
      Port[$61] := Ack or $80;
      Port[$61] := Ack;

      { Flag finished on release of Esc key }
      if Code = $81 then Disable := true;

      { Display received codes }
      write (Hex[Code shr 4], Hex[Code and $F]);
      if (Code <> $E0) and (Code >= $80) then
        write (': ')
      else
        write ('  ');
      { Post interrupt processing complete}
      Port[$20] := $20;
    end {INT09};

  begin

    writeln ('This program displays codes received from the keyboard');
    writeln ('controller via interrupt 09. Terminate the program by');
    writeln ('pressing the Esc key!');
    writeln;

    Disable := false;

    { Save old interrupt vector and point to our routine }
    GetIntVec ($09, OldInt09);
    SetIntVec ($09, @INT09);

    { wait for termination flag }
    repeat until Disable;

    { restore old interrupt vector }
    SetIntVec ($09, OldInt09);

  end {CODE}.

