/*Copyright (C) 1992, 1994 by Thomas Glen Smith.  All Rights Reserved.*/
/* treeroot APL2 V1.0.0 ************************************************
* Called by aplinit, apllov1, compute, and funcmain to add a new root  *
* to the tree.                                                         *
***********************************************************************/
#define INCLUDES APLFUNCI+APLMEM+APLTOKEN+STRING+TREE
#include "includes.h"
Treelist treeroot(fp)
Aplfunc fp; /* Function definition structure. */
{
	extern int aplerr;
	extern Treelist treehdr;
	Treelist new,treesave;

	treesave = treehdr;
	new = malloc(sizeof(struct treelist)); /* new root */
	if (new != NULL) {
		new->avlhdr = NULL;
		new->treenext = treehdr;
		treehdr = new;
		new->avlfun = fp;
		new->avlstmt = 0;
		if (fp == NULL)
			new->avlfname = NULL;
		else {
			new->avlfname = malloc(strlen(
				fp->funcname->token_ptr.token_string)+1);
			if (new->avlfname != NULL)
				strcpy(new->avlfname,
					fp->funcname->token_ptr.token_string);
		}
		new->indxsave = 0;
		new->indxhold = 0;
		new->fuzzsave = 0;
		new->fuzzhold = 0e0;
		new->avlexec = NULL;
		new->avltokhd = NULL;
		new->lastfun = 0;
		new->avloff = 0;
		new->treeflag = 0;
	}
	return(new);
}
