/* Copyright (C) 1994 by Thomas Glen Smith.	All Rights Reserved. */
/* scalay APL2 V1.0.0 **************************************************
* Called from nwisec to determine the scalar processing function.	 *
***********************************************************************/
#define INCLUDES APLCB+FUNCODES+FUNSTRUC
#include "includes.h"
void *scalay(fun,code,intype,outype)
void *fun; /* function structure - see funstruc.h */
int code; /* function code extracted from *fun. */
int intype,outype; /* input and output data types */
{

	switch(intype) {
     	case APLCHAR:
          	return(((Eqne *)fun)->ph);
          case APLINT:
              	switch(code) { /* outype m/b APLINT */
                   	case EQNE:
                    	return(((Eqne *)fun)->rel.dyad.procs.ppint);
                    case SCDO:
                    	return(((Rela *)fun)->dyad.procs.ppint);
               }
          case APLNUMB:
          	if (outype == APLINT)
               	switch(code) {
                    	case EQNE:
                         	return(((Eqne *)fun)->rel.dyad.procs.ppmix);
                         case SCDO:
                         	return(((Rela *)fun)->dyad.procs.ppmix);
                         case SCMD:
                         	return(((Scalars *)fun)->dyad.procs.ppmix);
                    }
               else switch(code) { /* outype m/b APLNUMB */
                    	case EQNE:
                         	return(((Eqne *)fun)->rel.dyad.procs.ppdbl);
                         case SCDO:
                         	return(((Rela *)fun)->dyad.procs.ppdbl);
                         case SCMD:
                         	return(((Scalars *)fun)->dyad.procs.ppdbl);
               }
     }
     return(NULL); /* should not happen, but just in case. */
}
