/*Copyright (C) 1992, 1996 by Thomas Glen Smith.  All Rights Reserved.*/
/* savfsfn APL2 V1.0.0 *************************************************
* Called from savfsub to save a function definition.                   *
***********************************************************************/
#define INCLUDES APLCB+APLFUNCI+APLTOKEN+IO+STDIO+STRING
#include "includes.h"
void savfsfn(fp,func)
int fp; /* file descriptor handle */
Aplfunc func; /* function definition to save */
{
	Ptrtoff; Savfscb; Savfsfo; Strwrite;
	Apltoken tok,*tokhdr;
	int i,*ip,j,k;

	i = write(fp,&(func->funcflag),sizeof(func->funcflag));
	i = write(fp,&(func->functype),sizeof(func->functype));
	i = write(fp,&(func->functotl),sizeof(func->functotl));
	i = write(fp,&(func->funcstmt),sizeof(func->funcstmt));

	i = write(fp,func->functokc,func->funcstmt*sizeof(int));
		/* write array of token counters. */
	tok = func->functary; /* point to array of tokens */
	for ( j = func->functotl ; j > 0 ; j-- ) {
		tok->token_queue.token_next_offset =
			ptrtoff((char*)(func->functary),
			(char*)(tok->token_queue.token_next_ptr));
		tok++; /* bump to next token */
	}
	savfscb(fp, func->functext); /* write text aplcb */
	j = ptrtoff((char*)(func->functary), (char*)(func->funcname));
	i = write(fp, &j, sizeof(j)); /* and write it. */
	i = write(fp, func->functary, 
		func->functotl * sizeof(struct apltoken));
	tokhdr = func->functokp; /* point to array of token headers */
	for ( j = func->funcstmt ; j > 0 ; j-- ) {
		k = ptrtoff((char*)(func->functary), (char*)(*tokhdr++));
		i = write(fp, &k, sizeof(k)); /* and write it. */
	}
	j = ptrtoff((char*)(func->functary), (char*)(func->funcvars));
	i = write(fp, &j, sizeof(j)); /* and write it */
	j = ptrtoff((char*)(func->functary), (char*)(func->funclabs));
	i = write(fp, &j, sizeof(j));
	savfsfo(fp,func); /* go write token elements */
}
