/* Copyright (C) 1992 by Thomas Glen Smith.  All Rights Reserved. */
/* rotatesb APL2 V1.0.0 ************************************************
* Called from rotate to complete processing after error checking is    *
* complete and initial values set.                                     *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb rotatesb(left,rite,out,axis,axicnt,botcnt,topcnt,lincr)
Aplcb left,rite,out;
int axis,axicnt,botcnt,topcnt,lincr;
{
	Dtacopy; Errstop; Imod;
	extern int aplerr;
	int a,b,c,datatyp,*ep,i,j,k,l,*lp,m,n,p,size;
	char *ip,*op;

	datatyp = rite->aplflags & (APLMASK + APLAPL);
	size = rite->aplsize; /* item size */
	op = out->aplptr.aplchar;
	m = size*botcnt; /* Bump amount. */
	lp = left->aplptr.aplint; /* addr(rotate amount) */
	ep = left->aplptr.aplint + left->aplcount; /* end check */
	for (i=0; i<topcnt; i++) {
		ip = rite->aplptr.aplchar + i * axicnt * m;
		for (j=0; j<axicnt; j++) {
			for (k=0; k<botcnt; k++) {
				op = dtacopy(op,
					ip + m * imod((*lp)+j,axicnt) + k * size, 
					1, 1, datatyp);
				if (axis != rite->aplrank) {
					lp += lincr; /* bump rotate amt ptr */
					if (lp == ep)
						lp = left->aplptr.aplint;
				}
			}
		}
		if (axis == rite->aplrank) {
			lp += lincr; /* bump rotate amt ptr */
			if (lp == ep)
				lp = left->aplptr.aplint;
		}
	}
	return(errstop(0,left,rite,out));
}
