/*Copyright (C) 1992, 1996 by Thomas Glen Smith.  All Rights Reserved.*/
/* rmonadic APL2 V1.0.0 ************************************************
* Almost identical in structure and function to imonadic, rmonadic     *
* applies an operator to a double floating point APL variable to       *
* produce an integer result.                                           *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb rmonadic(oper,rite)
int (*oper)(); /* operator */
Aplcb rite; /* operand */
{
	Errinit; Errstop; Getcb; Intcopy; Real;
     extern int aplerr;
	int *dataout,*dimptr,*dimrite,i;
	double *datarite;
     Aplcb out;

	if (errinit())
		return(errstop(0,NULL,rite,NULL));
	if (!(rite->aplflags & APLNUMB)) {
		rite = real(rite);
		if (aplerr)
			return(NULL);
	}
	out = getcb(NULL,rite->aplcount,APLINT+APLTEMP,rite->aplrank,NULL);
	if (!out->aplcount)
		return(errstop(0,NULL,rite,out));
	if (out->aplrank>1)
		dimptr=intcopy(out->apldim,rite->apldim,out->aplrank,1);
	dataout = out->aplptr.aplint;
	datarite = rite->aplptr.apldata;
	for (i = out->aplcount; i > 0; i--)
		*dataout++ = (*oper)(*datarite++);
	return(errstop(0,NULL,rite,out));
}
