/* Copyright (C) 1994 by Thomas Glen Smith.  All Rights Reserved. */
/* memixcm APL2 V1.0.0 *************************************************
* Called from both member and indexof to complete processing.  Member  *
* will set key=0, indexof sets it to 1.                                *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb memixcm(key,left,rite)
int key;
Aplcb left,rite;
{
	Errstop; Getcb; Intcopy; Matchok;
	Memixb; Memixc; Memixd; Memixe; Memixf;
     Aplcb out;
     int *dimptr;

	if (!matchok(&left,&rite,APLMASK | APLAPL))
		return(NULL); /* Any data types that match are ok. */
	out = getcb(NULL,rite->aplcount,APLINT+APLTEMP,rite->aplrank,NULL);
	if (out->aplrank > 1)
		dimptr = intcopy(out->apldim,rite->apldim,out->aplrank,1);
	if (0 == out->aplcount) /* empty? */
		return(errstop(0,left,rite,out)); /* done if empty */
	switch (left->aplflags & (APLMASK | APLAPL)) {
		case APLNUMB:
			return(memixb(key,left,rite,out));
		case APLINT:
			return(memixc(key,left,rite,out));
		case APLCHAR:
			return(memixd(key,left,rite,out));
		case APLAPL:
			return(memixe(key,left,rite,out));
		case APLCPLX:
			return(memixf(key,left,rite,out));
	} /* end switch */
}
