/* Copyright (C) 1994 by Thomas Glen Smith.  All Rights Reserved. */
/* innrprda APL2 V1.0.0 ************************************************
* Called by innrcom to obtain the output aplcb.                        *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb innrprda(left,rite,ptype)
Aplcb left,rite;
int ptype; /* output data type */
{
	Cat; Drop; Getcb; Iscalar; Intcopy; Ireduce; Itimes; Perm; Shape;
		Temp;
	extern int indxorg;
	Aplcb dimcb, out=NULL;
	int *ip,itimesid=1,leftsave,rank,ritesave;

	if (leftsave = left->aplflags & APLTEMP)
		left->aplflags -= APLTEMP;
	if (ritesave = rite->aplflags & APLTEMP)
		rite->aplflags -= APLTEMP;
	dimcb = perm(
		cat(
			drop(
				iscalar(-1),
				shape(left)
			),
			drop(
				iscalar(1),
				shape(rite)
			),
			indxorg
		)
	);
	rank = dimcb->aplcount;
	out = getcb(NULL,
		ivalue(
			ireduce(
				itimes,
				&itimesid,
				dimcb,
				indxorg
			)
		),
		ptype + APLTEMP,
		rank,
		NULL
	);
	if (rank > 1) /* copy dimensions if rank > vector */
		ip = intcopy(out->apldim,dimcb->aplptr.aplint,rank,1);
	endoper(temp(dimcb));
	left->aplflags += leftsave;
	rite->aplflags += ritesave;
	return(out);
}
