/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* imonadic APL2 V1.0.0 ************************************************
* Called by drop and transpot. The integer equivalent of monadic.      *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb imonadic(oper,rite)
int (*oper)(); /* operator */
Aplcb rite; /* operand */
{
	Getcb; Errinit; Errstop; Intcopy; Integer;
	extern int aplerr;
	int *dataout,*datarite,*dimptr,*dimrite,i;
	Aplcb out;

	if (errinit())
		return(errstop(0,NULL,rite,NULL));
	if (!(rite->aplflags & APLINT)) {
		rite=integer(rite);
		if (aplerr)
			return(NULL);
	}
	out = getcb(NULL,rite->aplcount,APLINT+APLTEMP,rite->aplrank,NULL);
	if (out == NULL)
		return(errstop(0,NULL,rite,NULL));
	if (!out->aplcount)
		return(errstop(0,NULL,rite,out));
	if (out->aplrank>1)
		dimptr = intcopy(out->apldim,rite->apldim,out->aplrank,1);
	dataout = out->aplptr.aplint;
	datarite = rite->aplptr.aplint;
	for (i = out->aplcount; i > 0; i--)
		*dataout++ = (*oper)(*datarite++);
	return(errstop(0,NULL,rite,out));
}

