/*Copyright (C) 1992, 1996 by Thomas Glen Smith.  All Rights Reserved.*/
/* imod APL2 V1.0.0 *****************************************************
* Called by rotatesb.                                                   *
* Given two operands of type int, imod returns the remainder from the   *
* division of the first operand by the second. e.g. mod(5,2) => 3,      *
* mod(5,-2) => 3, and mod(-5,-2) => -2.  In pseudo-code, the logic for  *
* the answer is as follows:                                             *
*          quotient := 0                                                *
*      loop                                                             *
*          remainder := numerator - quotient X denominator              *
*          if (sign(remainder) == sign(denominator) &&                  *
*            abs(remainder) < abs(denominator)) break                   *
*          quotient += sign(denominator) X sign(numerator)              *
*          next loop                                                    *
************************************************************************/
#define INCLUDES 0
#include "includes.h"
int imod(num,den)
int num,den;
{
	int i;

	if (den == 0) return(num); /* den | num = num */
	if (num == 0) return(0);
	if (0 == (i = num % den)) return(0);
	if ((num > 0 && den > 0) || (num < 0 && den < 0)) return(i);
	return(i+den);
}
