/* Copyright (C) 1994 by Thomas Glen Smith.	All Rights Reserved. */
/* formspp APL2 V1.0.0 *************************************************
* Called by formatk to adjust the values to be formatted for Lpp.	 *
* Suppose one of the values is 12345j.00034, and Lpp is set to 3.      *
* .00034 must be treated as 0 to limit significance to 3 digits.       *
***********************************************************************/
#define INCLUDES APLCB+MATH
#include "includes.h"
Aplcb formspp(rite)
Aplcb rite;
{
	Log;
	extern double pp;
	int iw,mypp;
	double absdif,dif,dw,*ip,logimag,log10,logreal;

	mypp = pp;
	if (mypp < 0 || mypp > 10) mypp = 10; /* be realistic */
	if (mypp < 10) {
		log10 = log(10.0);
		ip = rite->aplptr.apldata;
		iw = rite->aplcount;
		while(iw--) {
			if (*ip != 0e0 && *(ip+1) != 0e0) {
				dw = (*ip > 0e0) ? *ip : -*ip;
				logreal = log(dw); /* Natural log. */
				dw = (*(ip+1) > 0e0) ? *(ip+1) : -*(ip+1);
				logimag = log(dw); /* Natural log. */
				dif = (logreal - logimag) / log10; /* Significance */
				absdif = (dif < 0) ? -dif : dif;   /* ratio. */
				if (absdif > mypp) /* Ratio too large for print. */
					if (logreal < logimag)
						*ip = 0e0;
					else *(ip+1) = 0e0;
			}
			ip += 2;
		}
	}
}
