/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* formdfu APL2 V1.0.0 *************************************************
* Formdfu is called by formdfs.                                        *
***********************************************************************/
#define INCLUDES STDIO+APLCB
#include "includes.h"
#undef max
#define max(A, B) ((mxl = (A)) > (mxr = (B)) ? mxl : mxr)
Aplcb formdfu(cols,rows,dimcnt,v,rowblp,rowhip,icb,ocb,rcb,
     chrcb,cntcb,colbl,colwi,frmcb,numcb,rite,rowbl,rowhi)
#include "formdft.h" /* Common declarations. */
Aplcb rite; int *rowblp,*rowhip,v; /* v = 1 if output is vector */
{    Formdfs; Formdfx; Formdfv;
     extern int aplerr,indxorg; Aplcb ip,lastip,op;
     int *chrp,*colblp,*colwip,hitot=0,i,j,k,m,mxl,mxr,notchara,
     *nump,n,notcharb,ranka,rankb,rowheight,rowspaces,sptot=0,wip;

     for (i = rows; i > 0 && aplerr == 0; i--) {
          lastip = NULL; /* prior column element in this row of output */
          colblp = colbl->aplptr.aplint; /* 1st column spaces counter */
          colwip = colwi->aplptr.aplint; /* 1st column width counter */
          nump   = numcb->aplptr.aplint; /* 1st column numeric flag */
          chrp   = chrcb->aplptr.aplint; /* 1st column character flag */
          rowheight = rowspaces = 0; /* initialize */
          for (j = cols; j > 0 && aplerr == 0; j--)  {
               ip = *icb++; /* point to next input aplcb */
               *nump++ &= notcharb = !(ip->aplflags & APLCHAR);
               *chrp++ &= !notcharb; /* character-only column? */
               rankb = ip->aplrank;
               *ocb++ = op = formdfs(ip); /* formatted vector/matrix */
               if (aplerr) return(NULL);
               k = (op->aplrank < 2); /* test for vector element */
               v &= k; /* test for vector output */
               wip = (op->aplrank) ? *(op->apldim+(k==0)) : 1;
               wip = max(wip, *colwip);
               *colwip++ = wip;
               if (lastip && colblp != NULL) {
                    m = max(ranka + notchara, rankb + notcharb);
                    m = max(m, *colblp);
                    *colblp++ = m;
               }
               lastip = ip;
               notchara = notcharb;
               ranka = rankb;
               m = (k) ? 1 : *(op->apldim); /* element height */
               if (m > rowheight) rowheight = m;
               if (i < rows) { /* do horizontal space between rows? */
                    m = -1 + max(ranka, (*rcb++)->aplrank);
                    if (m > rowspaces) rowspaces = m;
          }    }
          if (dimcnt > 2)  /* will there be interdimensional spacing? */
               rowspaces += formdfv(rite,cntcb);
          hitot += *rowhip++ = rowheight; /* save row height */
          if (i > 1)
               sptot += *rowblp++ = rowspaces; /* save spaces after row */
     }
     return(formdfx(v,cols,rows,hitot+sptot,frmcb,colbl,colwi,
          rowbl,rowhi,numcb,chrcb));
}
