/* Copyright (C) 1996 by Thomas Glen Smith.  All Rights Reserved. */
/* formbfv APL2 V1.0.0 *************************************************
* Called by formatv to loop through each field character.              *
***********************************************************************/
#define INCLUDES STDIO+STRING+FORM
#include "includes.h"
void formbfv(bs,fs,pold,pofd,oq,gch,fldptr,fldint,bdi,fdi,bpl,fpl,fln)
char *bs,*fs,**pold,**pofd,*oq,*gch,**fldptr;
int *fldint,bdi,fdi,bpl,fpl,fln;
{
	Formbfw; Formbfx;
	extern int aplerr;
	char ch,fch,*fct,*pz;

	while(fln--) { /* Once for each field character. */
		fch = *(fct = fs++); /* Next char from model field. */
		if (fch >= '0' && fch <= '9') { /* Field character digit? */
			*pold = oq; /* Save A(last output digit). */
			if (fdi) { /* Left of decimal point? */
				if (fdi-- == bdi) {
					bdi--;
					if (*pofd == NULL)
						*pofd = oq; /* A(1st output digit). */
					*oq++ = *bs++; /* Output value digit. */
				}
				else *oq++ = formbfx(fldptr,fct,pofd,oq); /*fdi>bdi*/
			}
			else { /* We're working right of decimal point. */
				if (fpl-- == bpl--)
					*oq++ = *bs++; /* Output value decimal. */
				else
					if (bpl < 0) { /* fpl > bpl. */
						ch = ' ';
						if (NULL != (pz = RIGHT_PAD_ZEROS(fldptr)))
							if (pz >= fct)
								ch = '0';
						*oq++ = ch;
					}
					else *oq++ = *bs++; /* fpl < bpl. */
			}
		}
		else if (fch == '.') {
			if (fpl && 
				(bpl || RIGHT_PAD_ZEROS(fldptr) != NULL))
				*oq++ = *(gch+0); /* Lfc[1] (decimal point) */
			bs++; /* bump past d.p. in buffer */
		}
		else if (fch == ',')
			*oq++ = *(gch+1); /* Lfc[2] (comma) */
		else if (fch == *(gch+4))
			*oq++ = ' '; /* Lfc[5] (print as blank) */
		else *oq++ = formbfw(fch,fct,fdi,fldptr,fldint);
			/* It is either decorator or literal. */
	}
}

