/* Copyright (C) 1995 by Thomas Glen Smith.  All Rights Reserved. */
/* formatw APL2 V1.0.0 *************************************************
* Called by formatv after all other formatting on the output field is  *
* done to float the left and right decorators if necessary.  Returns a *
* pointer to the next available output position.                       *
***********************************************************************/
#define INCLUDES FORM
#include "includes.h"
char *formatw(fldptr,fldint,neg,ofd,old)
char **fldptr; /* Ptr to array of ptrs into format control field. */
int	*fldint;	/* Ptr to array of int describing format control field. */
int	neg;		/* 1 if original value was negative, 0 if not. */
char *ofd;	/* Ptr to 1st digit in output for current value. */
char *old;	/* Ptr to last digit in output for current value. */
{
	int i;
	char *cp;

	if (!(FCCFLAGS(fldint) & FC4L)) /* Float left decorator asis? */
		if (0 < (i = (cp = FIRST_DIGIT(fldptr)) - START_OF_FIELD(fldptr)))
			/* Is there a left decorator? */
			if (		(neg && (FCCFLAGS(fldint) & FC1L))
					/* Float negative left decorator? */
				||	(!neg && (FCCFLAGS(fldint) & FC2L))
					/* Float positive left decorator? */
				||	(         FCCFLAGS(fldint) & FC3L ))
					/* Float left decorator, regardless of sign. */
			while(i--) *--ofd = *--cp; /* Float the decorator. */
	if (!(FCCFLAGS(fldint) & FC4R)) /* Float right decorator asis? */
		if (0 < (i = END_OF_FIELD(fldptr) - (cp = LAST_DIGIT(fldptr))))
			/* Is there a right decorator? */
			if (		(neg && (FCCFLAGS(fldint) & FC1R))
					/* Float negative right decorator? */
				||	(!neg && (FCCFLAGS(fldint) & FC2R))
					/* Float positive right decorator? */
				||	(         FCCFLAGS(fldint) & FC3R ))
					/* Float left decorator, regardless of sign. */
			while(i--) *++old = *++cp; /* Float the decorator. */
}
