/* Copyright (C) 1994 by Thomas Glen Smith.  All Rights Reserved. */
/* formatp APL2 V1.0.0 *************************************************
* Called by form when left is character and rite is non-empty and      *
* numeric, to do format-by-example.                                    *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb formatp(left,rite)
Aplcb left,rite;
{
	Errstop; Formatl; Formatq; Getcb; Intcopy; Real;
	extern int aplerr;
	int cnt,cols,i,*ip,ritetype,rows,width;
	char *ce,*cf,*cp,field[80],*start=NULL;
	Aplcb out=NULL;

	if (!(ritetype = rite->aplflags & (APLINT | APLNUMB)))
		return(errstop(132,left,NULL,rite)); /* m/b real */
	for(;;) {
		if (ritetype == APLINT) rite = real(rite);
		if (aplerr) break;
		ce = left->aplcount + (cp = left->aplptr.aplchar);
		cnt = 0;
		for (;;) {
			cp = formatl(field,cp,&start); /* Next field/decorator. */
			if (aplerr) break;
			if (start != NULL) cnt++; /* Bump count of fields. */
			if (cp == ce) break; /* all done */
		}
		if (rite->aplrank) {
			cols = *(rite->apldim + rite->aplrank - 1);
			i = rite->aplrank - 1;
		}
		else {
			cols = 1;
			i = 0;
		}
		width = left->aplcount;
		if (cnt != cols)
			if (cnt != 1)
				return(errstop(132,left,rite,NULL)); /* bad # fields */
			else width *= cols;
		rows = 1;
		while (i--)
			rows *= *(rite->apldim+i);
		if (aplerr) break;
		out = formatq(left,rite,cols,rows,width,cnt,field);
		break; /* get out of for loop */
	}
	return(errstop(0,left,rite,out));
}
