/*Copyright (C) 1992, 1994 by Thomas Glen Smith.  All Rights Reserved.*/
/* formatd APL2 V1.0.0 *************************************************
* Called from form when the left argument isn't null.  The width and   *
* precision specifications given in left will be checked and expanded  *
* as necessary, with widthcb and precb built therefrom to contain the  *
* width and precision specifications to use in the final formatting.   *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
void formatd(left,rite,cba)
Aplcb left,rite,cba;
{
	Cat; Integer; Iscalar; Perm; Reshape; Formatm;
     extern int aplerr, indxorg;
	int leftlen;

	if (left->aplflags & APLCHAR) aplerr=14; /* must be numeric */
	if (left->aplrank > 1) aplerr=25; /* must be scalar/vector */
	if (aplerr) return;
	leftlen=2**(rite->apldim+1); /* left length s/b twice the number
		of columns in rite */
	if (left->aplcount < 1 || (left->aplcount > 2 &&
		left->aplcount != leftlen)) {
		aplerr=26; /* wrong length */
		return;
	}
	if (left->aplcount == leftlen)
		left=integer(left); /* make a copy of left */
	else { /* extend left */
		if (!(left->aplflags & APLINT)) left = integer(left);
		if (left->aplcount==1)
			left=reshape(iscalar(leftlen),cat(iscalar(0),left,indxorg));
			/* Precisions are zero for now.  Figure it out later */
		else	left=reshape(iscalar(leftlen),left); /* precisions given */
		if (aplerr) return;
	}
	/* Left now has a pair of numbers for each column of rite */
	formatm(perm(left),rite,cba);
}
