/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* expungf APL2 V1.0.0 *************************************************
* Called from expunge and others to free storage for an array of       *
* tokens.                                                              *
***********************************************************************/
#define INCLUDES APLCB+APLCHDEF+APLMEM+APLTOKEN
#include "includes.h"
void *expungf(tokary,tokcnt)
Apltoken tokary; /* array of tokens */
int tokcnt; /* count of tokens in array */
{
	Endoper;
	Apltoken tok;
	Aplcb cb;

	tok = tokary; /* point to first token */
	while (tokcnt--) {
		switch (tok->token_code) {
			case QUOTE:
			case VECTOR_TOKEN:
				if (NULL != (cb = tok->token_ptr.token_vector)) {
					cb->aplflags |= APLTEMP;
					endoper(cb);
				}
				break;
			case OPERAND_TOKEN:
				free(tok->token_ptr.token_string);
				break;
		} /* end switch */
		tok++;
	}
	free(tokary); /* free all token memory */
}
