/* Copyright (C) 1993 by Thomas Glen Smith.	All Rights Reserved. */
/* execspel APL2 V1.0.0 ************************************************
* Called by execspet to do some tests to see if this is a selective	 *
* specification operation. Returns 0 if not, and funky_code otherwise. *
***********************************************************************/
#define INCLUDES APLCHDEF+APLDERIV+APLTOKEN
#include "includes.h"
int execspel(ptok,pax,parg)
Apltoken *ptok; /* w/b = token for E in e.g. (Er)#n      */
Apltoken *pax;  /* w/b = token for x in e.g. (E[x]r)#n   */
{
	Execnext; Execspey;
	int hit,i,namecnt=0,noexit;
	Aplderiv dp;
	Apltoken wrk;

	noexit = execnext(ptok,pax,&wrk,&namecnt);
	if (*ptok == NULL) return(-1);
	switch((*ptok)->token_code) {
		case FUNCTION_TOKEN:
			hit = execspey(*ptok);
			break;
		case DERIVED_FUNCTION:
			dp = (*ptok)->token_ptr.token_function;
			i = ((Codes *)(dp->deriv_op))->funky_code;
			switch(i) {
				case SLASH:
				case SLASH_BAR:
				case SLOPE:
				case SLOPE_BAR:
					hit = i;
					break;
			} /* end switch */
			break;
	} /* end switch */
	return(hit);
}
