/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* execqnlu APL2 V1.0.0 ************************************************
* Called from execqnl.  System function quad_nl, name list.            *
***********************************************************************/
#define INCLUDES APLCB+APLMEM+STRING
#include "includes.h"
#include "execqnli.h"
Aplcb execqnlu(p)
Nlparm p; /* structure for passing during recursion */
{
	Aplstr; Getcb; Pop;
	Aplcb out=NULL;
	Nlq op,ophdr;
	int cols,datacnt,rank,rows;
	char *cp;

	if (0 == (datacnt = (rows = p->outrows) * (cols = p->outcols)))
		rank = 1; /* empty vector */
	else
		rank = 2; /* matrix */ 
	out = getcb(NULL,datacnt,APLCHAR+APLTEMP,rank,NULL);
	if (rank == 2 && out != NULL) {
		*(out->apldim) = rows;
		*(out->apldim+1) = cols;
		cp = out->aplptr.aplchar; /* output data location */
		ophdr = p->nlphdr; /* get top of stack */
		while (NULL != (op = pop(&ophdr))) {
			cp = aplstr(cp, op->nlstr, cols); /* copy name, pad */
			free(op);
		}
	}
	return(out);
}
