/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* execqnl APL2 V1.0.0 *************************************************
* Called from execmonq. System function quad_nl, name list.            *
***********************************************************************/
#define INCLUDES APLCB+TREE
#include "includes.h"
#include "execqnli.h"
Aplcb execqnl(left,rite)
Aplcb left,rite;
{
	Errinit; Errstop; Execqnls; Execqnlu; Temp; Vectin;
	extern int aplerr;
	struct nlparm p;
	extern Treelist treehdr; /* variable tree stack */
	Treelist nexthdr,workhdr;
	int i,*ip;

	if (errinit()) return(errstop(0,left,rite,NULL));
	if (left != NULL && (APLCHAR != left->aplflags & APLMASK ||
		left->aplrank > 1))
		return(errstop(111,left,rite,NULL));
	rite = temp(vectin(rite)); /* ensure rite is integer vector */
	if (aplerr)
		return(errstop(0,left,rite,NULL));
	ip = rite->aplptr.aplint;
	i = rite->aplcount;
	p.lab = p.var = p.fun = 0;
	while (i--)
		switch (*ip++) {
			case 1:	p.lab = 1; break; /* labels */
			case 2:	p.var = 2; break; /* variables */
			case 3:	p.fun = 3; break; /* functions */
			default:	return(errstop(117,left,rite,NULL));
		}
	if (left == NULL) {
		p.delim = NULL;
		p.delen = 0;
	}
	else {
		p.delim = left->aplptr.aplchar;
		p.delen = left->aplcount;
	}
	p.outrows = p.outcols = 0;
	p.nlphdr = NULL; /* name stack */
	nexthdr = (Treelist) treehdr;
	while (NULL != (workhdr = (Treelist) nexthdr)) {
		nexthdr = workhdr->treenext; /* next tree */
		execqnls(workhdr->avlhdr,&p);
	}
	return(errstop(0,left,rite,execqnlu(&p)));
}
