/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* execqfxg APL2 V1.0.0 ************************************************
* Called from execqfxd when the function type must be either niladic   *
* or monadic, and there is no list of localized variables to process.  * 
***********************************************************************/
#define INCLUDES APLCB+APLFUNCI+APLTOKEN
#include "includes.h"
Apltoken execqfxg(fp,curtok,tokcnt,curvar)
struct aplfunc *fp; /* function definition structure */
Apltoken curtok; /* current token */
int tokcnt; /* count of tokens remaining */
Apltoken curvar; /* local variable list */
{
	Execqfxe; Fifo;
	extern int aplerr;
	Apltoken nametok;

	if (tokcnt == 0) { /* must be niladic */
		fp->functype += NILAD; /* form = F */
		return(curtok); /* function name token */
	}
	if (tokcnt == 1) { /* must be monadic */
		fp->functype += MONAD; /* form = F b */
		nametok = curtok; /* save function name */
		curtok = execqfxe(curtok-1,OPERAND_TOKEN,93); /* right opnd */
		curvar = fifo(&(fp->funcvars),curvar,curtok); /* var list */
		return(nametok); /* return function name token */
	}
	aplerr = 999; /* shouldn't happen */
	return(NULL);
}
