/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* execqfxb APL2 V1.0.0 ************************************************
* Called from execqfx to do the initial parsing of the statements in   *
* the new function.  On return, functokp and functary will be set.     *
***********************************************************************/
#define INCLUDES APLCB+APLFUNCI+APLMEM+APLTOKEN
#include "includes.h"
void execqfxb(fp)
struct aplfunc *fp; /* function definition structure */
{
	Execfree; Execpars; Execqfxc; Execqfxj; Execqfxk; Pop;
	extern int aplerr;
	Aplcb *cb,rite;
	Apltoken fromhdr,tok,*tokary;
	int chartype,stmtcnt,stmtno,stmtlen;
	char *cp;

	stmtcnt = fp->funcstmt =
		*(fp->functext->apldim); /* number of statements */
	execqfxj(fp); /* initialize arrays dependent on stmtcnt */
	if (aplerr) return;
	rite = fp->functext;
	tokary = fp->functokp;
	chartype = rite->aplflags & APLCHAR;
	if (chartype) /* Stmtlen fixed only for data type APLCHAR. */
		stmtlen = *(rite->apldim + 1); /* length each stmt string */
	else cb = rite->aplptr.aplapl; /* Addr(addr((1st nested aplcb)) */
	for (stmtno = 0; stmtno < stmtcnt && aplerr == 0; stmtno++) {
		if (chartype) { /* Set cp to addr(next stmt string). */
			cp = rite->aplptr.aplchar + stmtno*stmtlen;
		} else { /* Must type data type APLAPL. */
			rite = *cb++; /* Get next nested aplcb. */
			cp = rite->aplptr.aplchar; /* cp = addr(next stmt str) */
			stmtlen = rite->aplcount; /* length(next stmt str) */
		}
		*tokary++ = execpars(cp,stmtlen); /* go parse this stmt */
	}
	if (aplerr) {
		tokary = fp->functokp; /* now copy tokens */
		for (stmtno = 0; stmtno < stmtcnt; stmtno++) {
			fromhdr = *tokary++; /* next from token list header */
			while (NULL != (tok = pop(&fromhdr)))
				execfree(tok);
		}
	}
	else execqfxk(fp); /* count tokens, transform to contiguous block */
}
