/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* execjotc APL2 V1.0.0 ************************************************
* Called from execjot and execjota when each operand must be           *
* converted to complex or floating point if necessary.                 *
***********************************************************************/
#define INCLUDES APLCHDEF+FUNSTRUC+APLCB
#include "includes.h"
Aplcb execjotc(left,rite,ltype,rtype,rscp)
Aplcb left,rite; /* left and right arguments */
int ltype,rtype;          /* data types of left and right args */
Scalar_dyadics *rscp;     /* function definitions - see funstruc.h */
{
     Complex; Outrprdp; Real;
	Aplcb out=NULL;

	if (ltype == APLCPLX || rtype == APLCPLX &&
		NULL != rscp->procs.ppcpx) {
	     if (ltype != APLCPLX) left = complex(left); /* convert */
	     if (rtype != APLCPLX) rite = complex(rite); /* convert */
          out = outrprdp(rscp->procs.ppcpx,left,rite);
     }
	else if ((NULL != rscp->procs.ppdbl)) {
	     if (ltype != APLNUMB) left = real(left); /* convert */
	     if (rtype != APLNUMB) rite = real(rite); /* convert */
          out = outrprdp(rscp->procs.ppdbl,left,rite);
     }
     return(out);
}
