/*Copyright (C) 1992, 1994 by Thomas Glen Smith.	All Rights Reserved.*/
/* execgets APL2 V1.0.0 ************************************************
* Called from execgetr to try for QUAD_ variables.				 *
***********************************************************************/
#define INCLUDES APLCB+APLCHDEF+APLTOKEN
#include "includes.h"
Aplcb execgets(tok)
Apltoken tok; /* operand token */
{
	Execglc;Execqts;Execqtz;Getcb;Treesrch;
	extern int aplerr, indxorg;
	extern double fuzz; /* local comparison tolerance */
	extern double pp;	/* local print precision */
	extern char quadfc[],quadlx[],quadrl[];
	Aplcb out=NULL;

	switch (tok->token_code) {
		case QUAD_CT: /* comparison tolerance */
			out = getcb(NULL,1,APLNUMB + APLTEMP,0,NULL);
			if (out == NULL) break;
			*(out->aplptr.apldata) = fuzz;
			break;
		case QUAD_FC:
			out = treesrch(quadfc);
			if (out == NULL) aplerr = 59; /* undefined operand */
			break;
		case QUAD_IO: /* index origin */
			out = getcb(NULL,1,APLINT + APLTEMP,0,NULL);
			if (out == NULL) break;
			*(out->aplptr.aplint) = indxorg;
			break;
		case QUAD_LC: /* line counter */
			out = execglc();
			break;
		case QUAD_LX:
			out = treesrch(quadlx);
			if (out == NULL) aplerr = 59; /* undefined operand */
			break;
		case QUAD_PP: /* print precision */
			out = getcb(NULL,1,APLNUMB + APLTEMP,0,NULL);
			if (out == NULL) break;
			*(out->aplptr.apldata) = pp;
			break;
		case QUAD_RL:
			out = treesrch(quadrl);
			if (out == NULL) aplerr = 59; /* undefined operand */
			break;
		case QUAD_TS: /* Time stamp. */
			out = execqts();
			break;
		case QUAD_TZ: /* Time zone. */
			out = execqtz();
			break;
		default: out = NULL;
			break;
	} /* end switch */
	return(out);
}
