/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* execdyan APL2 V1.0.0 ************************************************
* Called from execdotf, execdyad, nreduces, and nwised,                          *
* to do a APL dyadic function, returning Aplcb.                        *
***********************************************************************/
#define INCLUDES APLCHDEF+FUNSTRUC+APLCB+TREE+APLTOKCD
#include "includes.h"
Aplcb execdyan(code,func,left,rite)
int code; /* token type */
void *func; /* function description */
Aplcb left,rite; /* arguments */
{
     Derived; Errstop; Execdyaj; Funcmain;
     extern Treelist treehdr;
     Aplcb (*dyad_func)(void *, Aplcb, Aplcb);

     if (code >= DEFINED_FUNCTION) {
          dyad_func = funcmain; /* user defined function */
          treehdr->lastfun = 2; /* last done was user defined */
     }
     else if (code == FUNCTION_TOKEN)
          dyad_func = execdyaj; /* builtin dyadics */
     else if (code == DERIVED_FUNCTION)
          dyad_func = derived;
     else return(errstop(65,left,rite,NULL)); /* unknown dyadic */
     return(dyad_func(func,left,rite));
}
