/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* execdyak APL2 V1.0.0 ************************************************
* Called from execdyaj after the axis value has been processed.        *
***********************************************************************/
#define INCLUDES APLTOKEN+APLCB+FUNSTRUC+APLDERIV
#include "includes.h"
Aplcb execdyak(fun,left,rite,axis)
void *fun;
Aplcb left, rite;
int axis;
{
     Axisdft; Errstop; Execdyas;
     void *sdp;
     sub_dyad ep;

     switch (execdyas(fun,&sdp,&ep)) {
		/* FLR, DIS, etc., are described in aplderiv.h */
          case FLR: return(ep.flr(sdp,left,rite));
          case DIX: return(ep.dix(left,rite));
          case DNL: return(ep.dnl(left,rite,NULL,NULL)); /* pick */
          case DOX: return(ep.dox(left,rite,NULL));
          case WAX:
               if (axis < 0)
                    axis = axisdft((Codes *)fun,
                         ((left->aplrank > rite->aplrank) ? left : rite));
               return(ep.wax(left,rite,axis));
          default : return(errstop(65,left,rite,NULL)); /* unknown */
     } /* end switch */
}
