/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* execbrkt APL2 V1.0.0 ************************************************
* Called from execexeg when a right bracket token is found.            *
***********************************************************************/
#define INCLUDES APLCHDEF+APLTOKEN+APLCB+TREE
#include "includes.h"
Apltoken execbrkt(brtok)
Apltoken brtok; /* right bracket token */
{
     Execexec; Execfree; Execpop; Lifo; Newtok; Pop;
     extern Treelist treehdr;
     extern int aplerr;
     Apltoken op,tok=NULL;
     int i;

     i = brtok->token_offset; /* save offset */
     execfree(brtok); /* free token for right bracket, maybe */
     brtok = newtok(AXIS_INDEX_TOKEN, 0, i, NULL, 0);
     if (brtok == NULL) return(NULL); /* out of storage */
     while (aplerr == 0) {
          op = execexec(); /* go evaluate */
          if (aplerr) break; /* all done if error */
          if (op == NULL) /*null?*/
               op = newtok(NULL_TOKEN, 0, brtok->token_offset, NULL, 0);
          if (aplerr) break; /* all done if error */
          op = lifo(&(brtok->token_ptr.token_stack),op); /* stack */
          if (NULL == (tok = pop(&(treehdr->avltokhd))))
               aplerr = 80; /* left bracket not found when expected */
          if (aplerr) break; /* all done if error */
          if (tok->token_code == LEFT_BRACKET) break;
          if (tok->token_code != SEMICOLON)
               aplerr = 81; /* semicolon not found when expected */
          execfree(tok); /* free semicolon, or whatever it is */
          tok = NULL; /* in case of early out */
     }
     execfree(tok); /* free token for left bracket */
     return(brtok); /* return stack token */
}
