/*Copyright (C) 1992, 1994 by Thomas Glen Smith.  All Rights Reserved.*/
/* execasgn APL2 V1.0.0 ************************************************
* Called from execdyad when the current operator is a left arrow.      *
***********************************************************************/
#define INCLUDES APLCHDEF+APLTOKEN+APLCB
#include "includes.h"
Aplcb execasgn(lefttok,rite)
Apltoken lefttok; /* token for left operand */
Aplcb rite;
{
	Aplnewl; Aplsrand; Assign; Execfree; Qquadout; Quadout;
#include "quadext.h"
	extern int aplerr;
	Aplcb out=NULL;

	switch (lefttok->token_code) {
		case OPERAND_TOKEN:
			out = assign(lefttok->token_ptr.token_string,rite);
			break;
		case QUAD_AV:
			out = assign(quadav,rite);
			break;
		case QUAD_CT:
			out = assign(quadct,rite);
			break;
		case QUAD_FC:
			out = assign(quadfc,rite);
			break;
		case QUAD_IO:
			out = assign(quadio,rite);
			break;
		case QUAD_LX:
			out = assign(quadlx,rite);
			break;
		case QUAD_PP:
			out = assign(quadpp,rite);
			break;
		case QUAD_RL:
			out = assign(quadrl,rite);
			aplsrand(out); /* Set random number seed. */
			break;
		case QUAD_TS:
			out = assign(quadts,rite);
			break;
		case QUAD_TT:
			out = assign(quadtt,rite);
			break;
		case QUAD_TZ:
			out = assign(quadtz,rite);
			break;
		case QUAD:
			out = quadout(rite);
			aplnewl();
			break;
		case QUOTE_QUAD:
			out = qquadout(rite);
			break;
		default:
			aplerr = 66; /* missing variable name */
			endoper(rite);
			out = NULL;
	}
	execfree(lefttok); /* free storage for left token */
	return(out);
}
